/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jxmpp.util.XmppStringUtils;

public class Occupant {
    private final MUCAffiliation affiliation;
    private final MUCRole role;
    private final String jid;
    private final String nick;

    Occupant(MUCItem item) {
        this.jid = item.getJid();
        this.affiliation = item.getAffiliation();
        this.role = item.getRole();
        this.nick = item.getNick();
    }

    Occupant(Presence presence) {
        MUCUser mucUser = (MUCUser)presence.getExtension("x", "http://jabber.org/protocol/muc#user");
        MUCItem item = mucUser.getItem();
        this.jid = item.getJid();
        this.affiliation = item.getAffiliation();
        this.role = item.getRole();
        this.nick = XmppStringUtils.parseResource((String)presence.getFrom());
    }

    public String getJid() {
        return this.jid;
    }

    public MUCAffiliation getAffiliation() {
        return this.affiliation;
    }

    public MUCRole getRole() {
        return this.role;
    }

    public String getNick() {
        return this.nick;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Occupant)) {
            return false;
        }
        Occupant occupant = (Occupant)obj;
        return this.jid.equals(occupant.jid);
    }

    public int hashCode() {
        int result = this.affiliation.hashCode();
        result = 17 * result + this.role.hashCode();
        result = 17 * result + this.jid.hashCode();
        result = 17 * result + (this.nick != null ? this.nick.hashCode() : 0);
        return result;
    }
}

