/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.cache;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;
import javax.transaction.TransactionManager;
import org.infinispan.api.async.AsyncCacheEntryProcessor;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.HotRodTransport;
import org.infinispan.hotrod.impl.cache.CacheEntryImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryVersionImpl;
import org.infinispan.hotrod.impl.cache.ClientStatistics;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.cache.RemoteQuery;
import org.infinispan.hotrod.impl.iteration.RemotePublisher;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.hotrod.impl.operations.ClearOperation;
import org.infinispan.hotrod.impl.operations.GetAllParallelOperation;
import org.infinispan.hotrod.impl.operations.GetAndRemoveOperation;
import org.infinispan.hotrod.impl.operations.GetOperation;
import org.infinispan.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.operations.PutAllParallelOperation;
import org.infinispan.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.hotrod.impl.operations.PutOperation;
import org.infinispan.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.hotrod.impl.operations.RemoveOperation;
import org.infinispan.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.hotrod.impl.operations.RetryAwareCompletionStage;
import org.infinispan.hotrod.impl.operations.SetIfAbsentOperation;
import org.infinispan.hotrod.impl.operations.SetOperation;
import org.infinispan.hotrod.near.NearCacheService;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class RemoteCacheImpl<K, V>
implements RemoteCache<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCacheImpl.class, Log.class);
    private final String name;
    private final HotRodTransport hotRodTransport;
    private final CacheOperationsFactory cacheOperationsFactory;
    private volatile boolean isObjectStorage;
    private final DataFormat dataFormat;
    private final ClientStatistics clientStatistics;

    public RemoteCacheImpl(HotRodTransport hotRodTransport, String name, TimeService timeService, NearCacheService<K, V> nearCacheService) {
        this(hotRodTransport, name, new ClientStatistics(hotRodTransport.getConfiguration().statistics().enabled(), timeService, nearCacheService), DataFormat.builder().build());
        hotRodTransport.getMBeanHelper().register(this);
    }

    private RemoteCacheImpl(RemoteCacheImpl<?, ?> instance, DataFormat dataFormat) {
        this(instance.hotRodTransport, instance.name, instance.clientStatistics, dataFormat);
    }

    private RemoteCacheImpl(HotRodTransport hotRodTransport, String name, ClientStatistics clientStatistics, DataFormat dataFormat) {
        this.name = name;
        this.hotRodTransport = hotRodTransport;
        this.dataFormat = dataFormat;
        this.clientStatistics = clientStatistics;
        this.cacheOperationsFactory = hotRodTransport.createCacheOperationFactory(name, clientStatistics);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public CompletionStage<CacheConfiguration> configuration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HotRodTransport getHotRodTransport() {
        return this.hotRodTransport;
    }

    @Override
    public CacheOperationsFactory getOperationsFactory() {
        return this.cacheOperationsFactory;
    }

    @Override
    public CompletionStage<V> get(K key, CacheOptions options) {
        byte[] keyBytes = this.keyToBytes(key);
        GetOperation gco = this.cacheOperationsFactory.newGetKeyOperation(this.keyAsObjectIfNeeded(key), keyBytes, options, this.dataFormat);
        CompletionStage<Object> result = gco.execute();
        if (log.isTraceEnabled()) {
            result.thenAccept(value -> log.tracef("For key(%s) returning %s", key, value));
        }
        return result;
    }

    @Override
    public K keyAsObjectIfNeeded(Object key) {
        return (K)(this.isObjectStorage ? key : null);
    }

    @Override
    public void close() {
        this.hotRodTransport.getMBeanHelper().unregister(this);
    }

    @Override
    public SocketAddress addNearCacheListener(Object listener, int bloomBits) {
        throw new UnsupportedOperationException("Adding a near cache listener to a RemoteCache is not supported!");
    }

    private byte[][] marshallParams(Object[] params) {
        if (params == null) {
            return Util.EMPTY_BYTE_ARRAY_ARRAY;
        }
        byte[][] marshalledParams = new byte[params.length][];
        for (int i = 0; i < marshalledParams.length; ++i) {
            byte[] bytes = this.keyToBytes(params[i]);
            marshalledParams[i] = bytes;
        }
        return marshalledParams;
    }

    public CompletionStage<PingResponse> ping() {
        return this.cacheOperationsFactory.newFaultTolerantPingOperation().execute();
    }

    @Override
    public byte[] keyToBytes(Object o) {
        return this.dataFormat.keyToBytes(o);
    }

    @Override
    public byte[] valueToBytes(Object o) {
        return this.dataFormat.valueToBytes(o);
    }

    @Override
    public RetryAwareCompletionStage<CacheEntry<K, V>> getEntry(K key, CacheOptions options) {
        GetWithMetadataOperation op = this.cacheOperationsFactory.newGetWithMetadataOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), options, this.dataFormat);
        return op.internalExecute();
    }

    @Override
    public RetryAwareCompletionStage<CacheEntry<K, V>> getEntry(K key, CacheOptions options, SocketAddress listenerAddress) {
        GetWithMetadataOperation op = this.cacheOperationsFactory.newGetWithMetadataOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), options, this.dataFormat, listenerAddress);
        return op.internalExecute();
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> putIfAbsent(K key, V value, CacheWriteOptions options) {
        PutIfAbsentOperation op = this.cacheOperationsFactory.newPutIfAbsentOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), options, this.dataFormat);
        return op.execute();
    }

    @Override
    public CompletionStage<Boolean> setIfAbsent(K key, V value, CacheWriteOptions options) {
        SetIfAbsentOperation<K> op = this.cacheOperationsFactory.newSetIfAbsentOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), options, this.dataFormat);
        return op.execute();
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> put(K key, V value, CacheWriteOptions options) {
        PutOperation op = this.cacheOperationsFactory.newPutKeyValueOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), options, this.dataFormat);
        return op.execute();
    }

    @Override
    public CompletionStage<Void> set(K key, V value, CacheWriteOptions options) {
        SetOperation<K> op = this.cacheOperationsFactory.newSetKeyValueOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), options, this.dataFormat);
        return op.execute();
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> getAndRemove(K key, CacheOptions options) {
        GetAndRemoveOperation op = this.cacheOperationsFactory.newGetAndRemoveOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), options, this.dataFormat);
        return op.execute();
    }

    @Override
    public CompletionStage<Boolean> replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        if (!(Objects.requireNonNull(version) instanceof CacheEntryVersionImpl)) {
            throw new IllegalArgumentException("Only CacheEntryVersionImpl instances are supported!");
        }
        ReplaceIfUnmodifiedOperation op = this.cacheOperationsFactory.newReplaceIfUnmodifiedOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), ((CacheEntryVersionImpl)version).version(), options, this.dataFormat);
        return op.execute().thenApply(r -> r.getCode().isUpdated());
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> getOrReplaceEntry(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        if (!(Objects.requireNonNull(version) instanceof CacheEntryVersionImpl)) {
            throw new IllegalArgumentException("Only CacheEntryVersionImpl instances are supported!");
        }
        ReplaceIfUnmodifiedOperation op = this.cacheOperationsFactory.newReplaceIfUnmodifiedOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), ((CacheEntryVersionImpl)version).version(), options, this.dataFormat);
        return op.execute().thenApply(r -> {
            if (r.getCode().isUpdated()) {
                return null;
            }
            return (CacheEntry)r.getValue();
        });
    }

    @Override
    public CompletionStage<Boolean> remove(K key, CacheOptions options) {
        RemoveOperation<K> op = this.cacheOperationsFactory.newRemoveOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), options, this.dataFormat);
        return op.execute();
    }

    @Override
    public CompletionStage<Boolean> remove(K key, CacheEntryVersion version, CacheOptions options) {
        if (!(Objects.requireNonNull(version) instanceof CacheEntryVersionImpl)) {
            throw new IllegalArgumentException("Only CacheEntryVersionImpl instances are supported!");
        }
        RemoveIfUnmodifiedOperation op = this.cacheOperationsFactory.newRemoveIfUnmodifiedOperation(key, this.keyToBytes(key), ((CacheEntryVersionImpl)version).version(), options, this.dataFormat);
        return op.execute().thenApply(r -> r.getValue() != null);
    }

    @Override
    public Flow.Publisher<K> keys(CacheOptions options) {
        this.assertRemoteCacheManagerIsStarted();
        Flowable flowable = Flowable.fromPublisher(new RemotePublisher(this.cacheOperationsFactory, "org.infinispan.server.hotrod.ToEmptyBytesKeyValueFilterConverter", Util.EMPTY_BYTE_ARRAY_ARRAY, null, 128, false, this.dataFormat)).map(CacheEntry::key);
        return FlowAdapters.toFlowPublisher((Publisher)flowable);
    }

    @Override
    public Flow.Publisher<CacheEntry<K, V>> entries(CacheOptions options) {
        this.assertRemoteCacheManagerIsStarted();
        return FlowAdapters.toFlowPublisher(new RemotePublisher(this.cacheOperationsFactory, null, Util.EMPTY_BYTE_ARRAY_ARRAY, null, 128, false, this.dataFormat));
    }

    @Override
    public CompletionStage<Void> putAll(Map<K, V> entries, CacheWriteOptions options) {
        PutAllParallelOperation putAllParallelOperation = this.cacheOperationsFactory.newPutAllOperation(null, options, this.dataFormat);
        return putAllParallelOperation.execute();
    }

    @Override
    public CompletionStage<Void> putAll(Flow.Publisher<CacheEntry<K, V>> entries, CacheWriteOptions options) {
        return Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(entries)).collect(Collectors.toMap(CacheEntry::key, CacheEntry::value)).concatMapCompletable(map -> Completable.fromCompletionStage(this.putAll((Map<K, V>)map, options))).toCompletionStage(null);
    }

    @Override
    public Flow.Publisher<CacheEntry<K, V>> getAll(Set<K> keys, CacheOptions options) {
        GetAllParallelOperation op = this.cacheOperationsFactory.newGetAllOperation(keys.stream().map(this::keyToBytes).collect(Collectors.toSet()), options, this.dataFormat);
        Flowable flowable = Flowable.defer(() -> Flowable.fromCompletionStage((CompletionStage)op.execute()).concatMapIterable(Map::entrySet).map(e -> new CacheEntryImpl(e.getKey(), e.getValue(), null)));
        return FlowAdapters.toFlowPublisher((Publisher)flowable);
    }

    @Override
    public Flow.Publisher<CacheEntry<K, V>> getAll(CacheOptions options, K[] keys) {
        GetAllParallelOperation op = this.cacheOperationsFactory.newGetAllOperation(Arrays.stream(keys).map(this::keyToBytes).collect(Collectors.toSet()), options, this.dataFormat);
        Flowable flowable = Flowable.defer(() -> Flowable.fromCompletionStage((CompletionStage)op.execute()).concatMapIterable(Map::entrySet).map(e -> new CacheEntryImpl(e.getKey(), e.getValue(), null)));
        return FlowAdapters.toFlowPublisher((Publisher)flowable);
    }

    @Override
    private Flow.Publisher<K> removeAll(Flowable<K> keys, CacheWriteOptions options) {
        Flowable keyFlowable = keys.concatMapMaybe(k -> Single.fromCompletionStage(this.remove(k, (CacheOptions)options)).mapOptional(removed -> removed != false ? Optional.of(k) : Optional.empty()));
        return FlowAdapters.toFlowPublisher((Publisher)keyFlowable);
    }

    @Override
    public Flow.Publisher<K> removeAll(Set<K> keys, CacheWriteOptions options) {
        return this.removeAll(Flowable.fromIterable(keys), options);
    }

    @Override
    public Flow.Publisher<K> removeAll(Flow.Publisher<K> keys, CacheWriteOptions options) {
        return this.removeAll(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(keys)), options);
    }

    @Override
    private Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Flowable<K> keys, CacheWriteOptions options) {
        Flowable entryFlowable = keys.concatMapMaybe(k -> Maybe.fromCompletionStage(this.getAndRemove(k, (CacheOptions)options)));
        return FlowAdapters.toFlowPublisher((Publisher)entryFlowable);
    }

    @Override
    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Set<K> keys, CacheWriteOptions options) {
        return this.getAndRemoveAll(Flowable.fromIterable(keys), options);
    }

    @Override
    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Flow.Publisher<K> keys, CacheWriteOptions options) {
        return this.getAndRemoveAll(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(keys)), options);
    }

    @Override
    public CompletionStage<Long> estimateSize(CacheOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> clear(CacheOptions options) {
        ClearOperation op = this.cacheOperationsFactory.newClearOperation();
        return op.execute();
    }

    @Override
    public Flow.Publisher<CacheEntryEvent<K, V>> listen(CacheListenerOptions options, CacheEntryEventType[] types) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> process(Set<K> keys, AsyncCacheEntryProcessor<K, V, T> task, CacheOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> processAll(AsyncCacheEntryProcessor<K, V, T> processor, CacheProcessorOptions options) {
        throw new UnsupportedOperationException();
    }

    protected void assertRemoteCacheManagerIsStarted() {
        if (!this.hotRodTransport.isStarted()) {
            String message = "Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.";
            Log.HOTROD.unstartedRemoteCacheManager();
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }

    @Override
    public <K1, V1> RemoteCache<K1, V1> withDataFormat(DataFormat newDataFormat) {
        Objects.requireNonNull(newDataFormat, "Data Format must not be null").initialize(this.hotRodTransport, this.name, this.isObjectStorage);
        return new RemoteCacheImpl<K, V>(this, newDataFormat);
    }

    @Override
    public void resolveStorage(boolean objectStorage) {
        this.isObjectStorage = objectStorage;
        this.dataFormat.initialize(this.hotRodTransport, this.name, this.isObjectStorage);
    }

    public boolean isObjectStorage() {
        return this.isObjectStorage;
    }

    @Override
    public CompletionStage<Void> updateBloomFilter() {
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return "RemoteCacheImpl " + this.name;
    }

    public ClientStatistics getClientStatistics() {
        return this.clientStatistics;
    }

    @Override
    public CloseableIterator<CacheEntry<Object, Object>> retrieveEntries(String filterConverterFactory, Object[] filterConverterParams, Set<Integer> segments, int batchSize) {
        Publisher remotePublisher = this.publishEntries(filterConverterFactory, filterConverterParams, segments, batchSize);
        return Closeables.iterator(remotePublisher, (int)batchSize);
    }

    @Override
    public <E> Publisher<CacheEntry<K, E>> publishEntries(String filterConverterFactory, Object[] filterConverterParams, Set<Integer> segments, int batchSize) {
        this.assertRemoteCacheManagerIsStarted();
        if (segments != null && segments.isEmpty()) {
            return Flowable.empty();
        }
        byte[][] params = this.marshallParams(filterConverterParams);
        return new RemotePublisher(this.cacheOperationsFactory, filterConverterFactory, params, segments, batchSize, false, this.dataFormat);
    }

    @Override
    public CloseableIterator<CacheEntry<Object, Object>> retrieveEntriesByQuery(RemoteQuery query, Set<Integer> segments, int batchSize) {
        Publisher remotePublisher = this.publishEntriesByQuery(query, segments, batchSize);
        return Closeables.iterator(remotePublisher, (int)batchSize);
    }

    @Override
    public <E> Publisher<CacheEntry<K, E>> publishEntriesByQuery(RemoteQuery query, Set<Integer> segments, int batchSize) {
        return this.publishEntries("iteration-filter-converter-factory", query.toFactoryParams(), segments, batchSize);
    }

    @Override
    public CloseableIterator<CacheEntry<Object, Object>> retrieveEntriesWithMetadata(Set<Integer> segments, int batchSize) {
        Publisher<CacheEntry<K, V>> remotePublisher = this.publishEntriesWithMetadata(segments, batchSize);
        return Closeables.iterator(remotePublisher, (int)batchSize);
    }

    @Override
    public Publisher<CacheEntry<K, V>> publishEntriesWithMetadata(Set<Integer> segments, int batchSize) {
        return new RemotePublisher(this.cacheOperationsFactory, null, null, segments, batchSize, true, this.dataFormat);
    }

    @Override
    public TransactionManager getTransactionManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTransactional() {
        return false;
    }
}

