/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.jacoco.maven.AbstractReportMojo;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ReportFormat {
    HTML{

        IReportVisitor createVisitor(AbstractReportMojo mojo, Locale locale) throws IOException {
            HTMLFormatter htmlFormatter = new HTMLFormatter();
            htmlFormatter.setOutputEncoding(mojo.outputEncoding);
            htmlFormatter.setLocale(locale);
            if (mojo.footer != null) {
                htmlFormatter.setFooterText(mojo.footer);
            }
            return htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(mojo.getOutputDirectory()));
        }
    }
    ,
    XML{

        IReportVisitor createVisitor(AbstractReportMojo mojo, Locale locale) throws IOException {
            XMLFormatter xml = new XMLFormatter();
            xml.setOutputEncoding(mojo.outputEncoding);
            return xml.createVisitor((OutputStream)new FileOutputStream(new File(mojo.getOutputDirectory(), "jacoco.xml")));
        }
    }
    ,
    CSV{

        IReportVisitor createVisitor(AbstractReportMojo mojo, Locale locale) throws IOException {
            CSVFormatter csv = new CSVFormatter();
            csv.setOutputEncoding(mojo.outputEncoding);
            return csv.createVisitor((OutputStream)new FileOutputStream(new File(mojo.getOutputDirectory(), "jacoco.csv")));
        }
    };


    abstract IReportVisitor createVisitor(AbstractReportMojo var1, Locale var2) throws IOException;
}

