/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.TransformerCommon;

public abstract class OptimizedInvocations {
    public static void defrostClassIfExists(AOPClassPool pool, String className) {
        CtClass existing = pool.getCached(className);
        if (existing != null) {
            existing.defrost();
        }
    }

    public static CtClass makeInvocationClass(AOPClassPool pool, boolean makeInnerClass, CtClass outerClass, String className, CtClass superInvocation) throws CannotCompileException, NotFoundException {
        CtClass invocation = OptimizedInvocations.makeInvocationClassNoCtors(pool, makeInnerClass, outerClass, className, superInvocation);
        CtConstructor[] cons = superInvocation.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            CtConstructor conTemplate = superInvocation.getDeclaredConstructors()[i];
            CtConstructor icon = CtNewConstructor.make((CtClass[])conTemplate.getParameterTypes(), (CtClass[])conTemplate.getExceptionTypes(), (CtClass)invocation);
            invocation.addConstructor(icon);
        }
        return invocation;
    }

    public static CtClass makeInvocationClassNoCtors(AOPClassPool pool, boolean makeInnerClass, CtClass outerClass, String className, CtClass superInvocation) throws CannotCompileException, NotFoundException {
        CtClass invocation;
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        if (makeInnerClass) {
            String innerClassName = className.substring(className.lastIndexOf(46) + 1);
            OptimizedInvocations.defrostClassIfExists(pool, outerClass.getName() + "$" + innerClassName);
            boolean classStatic = true;
            invocation = TransformerCommon.makeNestedClass(outerClass, innerClassName, classStatic);
            invocation.setSuperclass(superInvocation);
        } else {
            OptimizedInvocations.defrostClassIfExists(pool, className);
            invocation = TransformerCommon.makeClass((ClassPool)pool, className, superInvocation);
        }
        invocation.addInterface(untransformable);
        return invocation;
    }
}

