/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.ref.WeakReference;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryWithClassLoader;
import org.jboss.aop.advice.SecurityActions;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AspectFactoryWithClassLoaderSupport
implements AspectFactory,
AspectFactoryWithClassLoader {
    private static final Logger logger = Logger.getLogger(AspectFactoryWithClassLoaderSupport.class);
    private WeakReference<ClassLoader> loader;
    private ThreadLocal<ClassLoader> scopedClassLoader = new ThreadLocal();

    protected AspectFactoryWithClassLoaderSupport() {
    }

    @Override
    public void setClassLoader(ClassLoader cl) {
        this.loader = new WeakReference<ClassLoader>(cl);
    }

    protected ClassLoader getLoader() {
        ClassLoader scopedClassLoader = this.peekScopedClassLoader();
        if (scopedClassLoader != null) {
            return scopedClassLoader;
        }
        if (this.loader != null) {
            return (ClassLoader)this.loader.get();
        }
        return null;
    }

    @Override
    public void pushScopedClassLoader(ClassLoader scopedCl) {
        this.scopedClassLoader.set(scopedCl);
    }

    @Override
    public void popScopedClassLoader() {
        this.scopedClassLoader.set(null);
    }

    @Override
    public ClassLoader peekScopedClassLoader() {
        return this.scopedClassLoader.get();
    }

    protected Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = this.getLoader();
        if (cl == null) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("Using context classloader " + tcl + " to load aspect " + name));
            }
            return tcl.loadClass(name);
        }
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("Using scoped classloader " + cl + " to load aspect " + name));
        }
        return cl.loadClass(name);
    }
}

