/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.standalone.client.api.StandaloneClient;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.DuplicateDeploymentNameException;
import org.jboss.as.standalone.client.api.deployment.InitialDeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class DeploymentUtils
implements Closeable {
    private final List<AbstractDeployment> deployments = new ArrayList<AbstractDeployment>();
    private final StandaloneClient client = StandaloneClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
    private final ServerDeploymentManager manager = this.client.getDeploymentManager();

    public DeploymentUtils() throws UnknownHostException {
    }

    public DeploymentUtils(String archiveName, Package pkg) throws UnknownHostException {
        this();
        this.addDeployment(archiveName, pkg);
    }

    public DeploymentUtils(String archiveName, Package pkg, boolean show) throws UnknownHostException {
        this();
        this.addDeployment(archiveName, pkg, show);
    }

    public synchronized void addDeployment(String archiveName, Package pkg) {
        this.addDeployment(archiveName, pkg, false);
    }

    public synchronized void addDeployment(String archiveName, Package pkg, boolean show) {
        this.deployments.add(new Deployment(archiveName, pkg, show));
    }

    public synchronized void addWarDeployment(String archiveName, Package pkg) {
        this.addWarDeployment(archiveName, pkg, false);
    }

    public synchronized void addWarDeployment(String archiveName, Package pkg, boolean show) {
        this.deployments.add(new WarDeployment(archiveName, pkg, show));
    }

    public synchronized void deploy() throws DuplicateDeploymentNameException, IOException, ExecutionException, InterruptedException {
        InitialDeploymentPlanBuilder builder = this.manager.newDeploymentPlan();
        for (AbstractDeployment deployment : this.deployments) {
            builder = deployment.addDeployment(this.manager, (DeploymentPlanBuilder)builder);
        }
        this.manager.execute(builder.build()).get();
    }

    public synchronized void undeploy() throws ExecutionException, InterruptedException {
        InitialDeploymentPlanBuilder builder = this.manager.newDeploymentPlan();
        for (AbstractDeployment deployment : this.deployments) {
            builder = deployment.removeDeployment((DeploymentPlanBuilder)builder);
        }
        this.manager.execute(builder.build()).get();
    }

    public MBeanServerConnection getConnection() throws Exception {
        return JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi"), new HashMap()).getMBeanServerConnection();
    }

    public String showJndi() throws Exception {
        return (String)this.getConnection().invoke(new ObjectName("jboss:type=JNDIView"), "list", new Object[]{true}, new String[]{"boolean"});
    }

    @Override
    public void close() throws IOException {
        StreamUtils.safeClose((Closeable)this.client);
    }

    private class WarDeployment
    extends AbstractDeployment {
        final File realArchive;

        public WarDeployment(String archiveName, Package pkg, boolean show) {
            ArchivePath metaInf = ArchivePaths.create((String)"META-INF");
            WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)archiveName);
            archive.addPackage(pkg);
            File sourceMetaInf = this.getSourceMetaInfDir(archiveName);
            this.addFiles((ResourceContainer<?>)archive, sourceMetaInf, metaInf);
            System.out.println(archive.toString(show));
            this.realArchive = this.createArchive((Archive<?>)archive);
        }

        @Override
        protected File getRealArchive() {
            return this.realArchive;
        }
    }

    private class Deployment
    extends AbstractDeployment {
        final File realArchive;

        public Deployment(String archiveName, Package pkg, boolean show) {
            ArchivePath metaInf = ArchivePaths.create((String)"META-INF");
            JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)archiveName);
            archive.addPackage(pkg);
            File sourceMetaInf = this.getSourceMetaInfDir(archiveName);
            this.addFiles((ResourceContainer<?>)archive, sourceMetaInf, metaInf);
            System.out.println(archive.toString(show));
            this.realArchive = this.createArchive((Archive<?>)archive);
        }

        @Override
        protected File getRealArchive() {
            return this.realArchive;
        }
    }

    private abstract class AbstractDeployment {
        String deployment;

        private AbstractDeployment() {
        }

        public synchronized DeploymentPlanBuilder addDeployment(ServerDeploymentManager manager, DeploymentPlanBuilder builder) throws DuplicateDeploymentNameException, IOException, ExecutionException, InterruptedException {
            System.out.println("Deploying " + this.getRealArchive().getName());
            this.deployment = manager.addDeploymentContent(this.getRealArchive());
            return builder.add(this.deployment, this.getRealArchive()).deploy(this.deployment);
        }

        public synchronized DeploymentPlanBuilder removeDeployment(DeploymentPlanBuilder builder) {
            System.out.println("Undeploying " + this.getRealArchive().getName());
            return builder.undeploy(this.deployment).remove(this.deployment);
        }

        protected void addFiles(ResourceContainer<?> archive, File dir, ArchivePath dest) {
            for (String name : dir.list()) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    this.addFiles(archive, file, ArchivePaths.create((ArchivePath)dest, (String)name));
                    continue;
                }
                archive.addResource(file, ArchivePaths.create((ArchivePath)dest, (String)name));
            }
        }

        protected File getSourceMetaInfDir(String archiveName) {
            String name = "archives/" + archiveName + "/META-INF/MANIFEST.MF";
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url == null) {
                throw new IllegalArgumentException("No resource called " + name);
            }
            try {
                File file = new File(url.toURI());
                return file.getParentFile();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not get file for " + url);
            }
        }

        protected File getOutputDir() {
            File file = new File("target");
            if (!file.exists()) {
                throw new IllegalStateException("target/ does not exist");
            }
            if (!file.isDirectory()) {
                throw new IllegalStateException("target/ is not a directory");
            }
            if ((file = new File(file, "archives")).exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException("target/archives/ already exists and is not a directory");
                }
            } else {
                file.mkdir();
            }
            return file.getAbsoluteFile();
        }

        protected File createArchive(Archive<?> archive) {
            File realArchive = new File(this.getOutputDir(), archive.getName());
            ((ZipExporter)archive.as(ZipExporter.class)).exportZip(realArchive, true);
            return realArchive;
        }

        protected abstract File getRealArchive();
    }
}

