/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.as.domain.client.api.DomainClient;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.api.deployment.DeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.DeploymentSetActionsCompleteBuilder;
import org.jboss.as.domain.client.api.deployment.DomainDeploymentManager;
import org.jboss.as.domain.client.api.deployment.DuplicateDeploymentNameException;
import org.jboss.as.domain.client.api.deployment.InitialDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.RemoveDeploymentPlanBuilder;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.as.model.DomainModel;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class DomainDeploymentUtils
implements Closeable {
    private final List<Deployment> deployments = new ArrayList<Deployment>();
    private final DomainClient client = DomainClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
    private final DomainDeploymentManager manager = this.client.getDeploymentManager();

    public DomainDeploymentUtils() throws UnknownHostException {
    }

    public DomainDeploymentUtils(String archiveName, Package pkg) throws UnknownHostException {
        this();
        this.addDeployment(archiveName, pkg);
    }

    public DomainDeploymentUtils(String archiveName, Package pkg, boolean show) throws UnknownHostException {
        this();
        this.addDeployment(archiveName, pkg, show);
    }

    public synchronized void addDeployment(String archiveName, Package pkg) {
        this.addDeployment(archiveName, pkg, false);
    }

    public synchronized void addDeployment(String archiveName, Package pkg, boolean show) {
        this.deployments.add(new Deployment(archiveName, pkg, show));
    }

    public synchronized void deploy() throws DuplicateDeploymentNameException, IOException, ExecutionException, InterruptedException {
        InitialDeploymentPlanBuilder builder = this.manager.newDeploymentPlan();
        DeploymentSetActionsCompleteBuilder deployBuilder = null;
        for (Deployment deployment : this.deployments) {
            deployBuilder = deployment.addDeployment(this.manager, (DeploymentPlanBuilder)builder);
            builder = deployBuilder;
        }
        DeploymentPlan plan = deployBuilder.toServerGroup("main-server-group").rollingToServerGroup("other-server-group").build();
        this.manager.execute(plan).get();
    }

    public synchronized void undeploy() throws ExecutionException, InterruptedException {
        InitialDeploymentPlanBuilder builder = this.manager.newDeploymentPlan();
        RemoveDeploymentPlanBuilder removeBuilder = null;
        for (Deployment deployment : this.deployments) {
            removeBuilder = deployment.removeDeployment((DeploymentPlanBuilder)builder);
            builder = removeBuilder;
        }
        this.manager.execute(removeBuilder.toServerGroup("main-server-group").build()).get();
    }

    public MBeanServerConnection getServerOneConnection() throws Exception {
        return JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi"), new HashMap()).getMBeanServerConnection();
    }

    public String showServerOneJndi() throws Exception {
        return (String)this.getServerOneConnection().invoke(new ObjectName("jboss:type=JNDIView"), "list", new Object[]{true}, new String[]{"boolean"});
    }

    public MBeanServerConnection getServerTwoConnection() throws Exception {
        return JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1240/jmxrmi"), new HashMap()).getMBeanServerConnection();
    }

    public String showServerTwoJndi() throws Exception {
        return (String)this.getServerTwoConnection().invoke(new ObjectName("jboss:type=JNDIView"), "list", new Object[]{true}, new String[]{"boolean"});
    }

    @Override
    public void close() throws IOException {
        StreamUtils.safeClose((Closeable)this.client);
    }

    private class Deployment {
        final String archiveName;
        final Package pkg;
        final JavaArchive archive;
        final File realArchive;

        public Deployment(String archiveName, Package pkg, boolean show) {
            this.archiveName = archiveName;
            this.pkg = pkg;
            ArchivePath metaInf = ArchivePaths.create((String)"META-INF");
            this.archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)archiveName);
            this.archive.addPackage(pkg);
            File sourceMetaInf = this.getSourceMetaInfDir();
            this.addFiles(this.archive, sourceMetaInf, metaInf);
            System.out.println(this.archive.toString(show));
            this.realArchive = new File(this.getOutputDir(), this.archive.getName());
            ((ZipExporter)this.archive.as(ZipExporter.class)).exportZip(this.realArchive, true);
        }

        private void addFiles(JavaArchive archive, File dir, ArchivePath dest) {
            for (String name : dir.list()) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    this.addFiles(archive, file, ArchivePaths.create((ArchivePath)dest, (String)name));
                    continue;
                }
                archive.addResource(file, ArchivePaths.create((ArchivePath)dest, (String)name));
            }
        }

        public synchronized DeploymentSetActionsCompleteBuilder addDeployment(DomainDeploymentManager manager, DeploymentPlanBuilder builder) throws DuplicateDeploymentNameException, IOException, ExecutionException, InterruptedException {
            RemoveDeploymentPlanBuilder result;
            System.out.println("Deploying " + this.realArchive.getName());
            DomainModel dm = DomainDeploymentUtils.this.client.getDomainModel();
            DeploymentUnitElement due = dm.getDeployment(this.archiveName);
            if (due != null) {
                result = builder.replace(this.archiveName, this.realArchive);
                if (!due.isStart()) {
                    result = result.deploy(this.archiveName);
                }
            } else {
                result = builder.add(this.archiveName, this.realArchive).andDeploy();
            }
            return result;
        }

        public synchronized RemoveDeploymentPlanBuilder removeDeployment(DeploymentPlanBuilder builder) {
            System.out.println("Undeploying " + this.realArchive.getName());
            return builder.undeploy(this.archiveName).andRemoveUndeployed();
        }

        private File getSourceMetaInfDir() {
            String name = "archives/" + this.archiveName + "/META-INF/MANIFEST.MF";
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url == null) {
                throw new IllegalArgumentException("No resource called " + name);
            }
            try {
                File file = new File(url.toURI());
                return file.getParentFile();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not get file for " + url);
            }
        }

        private File getOutputDir() {
            File file = new File("target");
            if (!file.exists()) {
                throw new IllegalStateException("target/ does not exist");
            }
            if (!file.isDirectory()) {
                throw new IllegalStateException("target/ is not a directory");
            }
            if ((file = new File(file, "archives")).exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException("target/archives/ already exists and is not a directory");
                }
            } else {
                file.mkdir();
            }
            return file.getAbsoluteFile();
        }

        private void close(Closeable c) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

