/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.client.jms.runner;

import java.io.Closeable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.fakejndi.FakeJndi;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueRemove;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ServerSubsystemUpdate;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.standalone.client.api.StandaloneClient;
import org.jboss.as.standalone.client.api.StandaloneUpdateResult;

public class ExampleRunner {
    private static final String QUEUE_NAME = "createdTestQueue";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        QueueConnection conn = null;
        QueueSession session = null;
        StandaloneClient client = StandaloneClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
        DeploymentUtils utils = null;
        boolean actionsApplied = false;
        try {
            utils = new DeploymentUtils("fakejndi.sar", FakeJndi.class.getPackage());
            utils.deploy();
            JMSQueueAdd queueAdd = new JMSQueueAdd(QUEUE_NAME);
            queueAdd.setBindings(Collections.singleton(QUEUE_NAME));
            ExampleRunner.applyUpdates(Collections.singletonList(ServerSubsystemUpdate.create((AbstractSubsystemUpdate)queueAdd)), client);
            actionsApplied = true;
            QueueConnectionFactory qcf = ExampleRunner.lookup(utils, "RemoteConnectionFactory", QueueConnectionFactory.class);
            Queue queue = ExampleRunner.lookup(utils, QUEUE_NAME, Queue.class);
            conn = qcf.createQueueConnection();
            conn.start();
            session = conn.createQueueSession(false, 1);
            QueueReceiver recv = session.createReceiver(queue);
            recv.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    TextMessage msg = (TextMessage)message;
                    try {
                        System.out.println("---->Received: " + msg.getText());
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            });
            QueueSender sender = session.createSender(queue);
            for (int i = 0; i < 10; ++i) {
                String s = "Test" + i;
                System.out.println("----> Sending: " + s);
                TextMessage msg = session.createTextMessage(s);
                sender.send((Message)msg);
            }
            Thread.sleep(1000L);
        }
        finally {
            try {
                conn.stop();
            }
            catch (Exception ignore) {}
            try {
                session.close();
            }
            catch (Exception ignore) {}
            try {
                conn.close();
            }
            catch (Exception ignore) {}
            if (utils != null) {
                utils.undeploy();
            }
            StreamUtils.safeClose((Closeable)utils);
            if (actionsApplied) {
                JMSQueueRemove remove = new JMSQueueRemove(QUEUE_NAME);
                ExampleRunner.applyUpdates(Collections.singletonList(ServerSubsystemUpdate.create((AbstractSubsystemUpdate)remove)), client);
            }
            StreamUtils.safeClose((Closeable)client);
        }
    }

    static void applyUpdates(List<AbstractServerModelUpdate<?>> updates, StandaloneClient client) throws UpdateFailedException {
        for (StandaloneUpdateResult result : client.applyUpdates(updates)) {
            if (result.isSuccess()) continue;
            throw result.getFailure();
        }
    }

    private static <T> T lookup(DeploymentUtils utils, String name, Class<T> expected) throws Exception {
        MBeanServerConnection mbeanServer = utils.getConnection();
        ObjectName objectName = new ObjectName("jboss:name=test,type=fakejndi");
        Object o = mbeanServer.invoke(objectName, "lookup", new Object[]{name}, new String[]{"java.lang.String"});
        return expected.cast(o);
    }
}

