/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.domain.configs.runner;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.net.InetAddress;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.domain.client.api.DomainClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.staxmapper.XMLContentWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DomainClient client = null;
        try {
            client = DomainClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
            System.out.println("\nReading the domain configuration:\n");
            System.out.println(ExampleRunner.writeModel("domain", (XMLContentWriter)client.getDomainModel()));
            System.out.println("\nReading the list of active server managers:\n");
            List serverManagers = client.getServerManagerNames();
            for (String sm : serverManagers) {
                System.out.println(sm);
            }
            for (String sm : serverManagers) {
                System.out.println("\nReading host configuration for server manager " + sm + "\n");
                System.out.println(ExampleRunner.writeModel("host", (XMLContentWriter)client.getHostModel(sm)));
            }
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(client);
            throw throwable;
        }
        StreamUtils.safeClose((Closeable)client);
    }

    private static String writeModel(String element, XMLContentWriter content) throws Exception, FactoryConfigurationError {
        XMLMapper mapper = XMLMapper.Factory.create();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(bos);
        try {
            mapper.deparseDocument((XMLContentWriter)new RootElementWriter(element, content), writer);
        }
        catch (XMLStreamException e) {
            System.out.println("XML Content that was written prior to exception:");
            System.out.println(writer.toString());
            throw e;
        }
        finally {
            writer.close();
            bos.close();
        }
        return new String(baos.toByteArray());
    }

    private static class RootElementWriter
    implements XMLContentWriter {
        private final String element;
        private final XMLContentWriter content;

        RootElementWriter(String element, XMLContentWriter content) {
            this.element = element;
            this.content = content;
        }

        public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
            streamWriter.writeStartDocument();
            streamWriter.writeStartElement(this.element);
            this.content.writeContent(streamWriter);
            streamWriter.writeEndDocument();
        }
    }
}

