/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.domain.servers.runner;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.domain.client.api.DomainClient;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.HostServerAdd;
import org.jboss.as.model.HostServerRemove;
import org.jboss.as.model.HostServerUpdate;
import org.jboss.as.model.ServerElementSocketBindingGroupUpdate;
import org.jboss.as.model.ServerElementSocketBindingPortOffsetUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.staxmapper.XMLContentWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DomainClient client = null;
        try {
            ServerStatus status;
            client = DomainClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
            System.out.println("\nReading the list of configured servers:");
            HashMap<ServerIdentity, ServerStatus> statuses = new HashMap<ServerIdentity, ServerStatus>(client.getServerStatuses());
            for (Map.Entry server : statuses.entrySet()) {
                ServerIdentity serverIdentity = (ServerIdentity)server.getKey();
                System.out.println("\nServer:\n");
                System.out.println("server name:         " + serverIdentity.getServerName());
                System.out.println("server manager name: " + serverIdentity.getHostName());
                System.out.println("server group name:   " + serverIdentity.getServerGroupName());
                System.out.println("status:              " + server.getValue());
            }
            List<ServerIdentity> servers = ExampleRunner.findUsefulServers(statuses, ServerStatus.STARTED);
            for (ServerIdentity serverIdentity : servers) {
                System.out.println("\nReading runtime configuration for " + serverIdentity.getServerName() + "\n");
                ServerModel sm = client.getServerModel(serverIdentity.getHostName(), serverIdentity.getServerName());
                if (sm == null) {
                    System.out.println("ERROR: server model is null");
                    continue;
                }
                System.out.println(ExampleRunner.writeModel("server", (XMLContentWriter)sm));
            }
            for (ServerIdentity serverIdentity : servers) {
                System.out.println("\nStopping server " + serverIdentity.getServerName() + "\n");
                status = client.stopServer(serverIdentity.getHostName(), serverIdentity.getServerName(), -1L, TimeUnit.SECONDS);
                System.out.println("Stop executed. Server status is " + status);
                statuses.put(serverIdentity, status);
            }
            servers = ExampleRunner.findUsefulServers(statuses, ServerStatus.STOPPED);
            for (ServerIdentity serverIdentity : servers) {
                System.out.println("\nStarting server " + serverIdentity.getServerName() + "\n");
                status = client.startServer(serverIdentity.getHostName(), serverIdentity.getServerName());
                System.out.println("Start executed. Server status is " + status);
                statuses.put(serverIdentity, status);
            }
            Thread.sleep(2000L);
            servers = ExampleRunner.findUsefulServers(statuses, ServerStatus.STARTED);
            for (ServerIdentity serverIdentity : servers) {
                System.out.println("\nRestarting server " + serverIdentity.getServerName() + "\n");
                status = client.restartServer(serverIdentity.getHostName(), serverIdentity.getServerName(), -1L, TimeUnit.SECONDS);
                System.out.println("Restart executed. Server status is " + status);
                statuses.put(serverIdentity, status);
            }
            Thread.sleep(2000L);
            System.out.println("\nCurrent server statuses\n");
            for (Map.Entry entry : client.getServerStatuses().entrySet()) {
                ServerIdentity id = (ServerIdentity)entry.getKey();
                System.out.println("\nServer:\n");
                System.out.println("server name:         " + id.getServerName());
                System.out.println("server manager name: " + id.getHostName());
                System.out.println("server group name:   " + id.getServerGroupName());
                System.out.println("status:              " + entry.getValue());
            }
            Thread.sleep(2000L);
            String serverName = "example-server";
            System.out.println("\nCreating new server: example-server\n");
            List list = client.getServerManagerNames();
            String serverManagerName = (String)list.get(0);
            System.out.println("Adding to server manager: " + serverManagerName);
            String serverGroup = (String)client.getDomainModel().getServerGroupNames().iterator().next();
            System.out.println("Adding to server group: " + serverGroup);
            ArrayList<Object> updates = new ArrayList<Object>(2);
            updates.add(new HostServerAdd("example-server", serverGroup));
            updates.add(HostServerUpdate.create((String)"example-server", (AbstractModelUpdate)new ServerElementSocketBindingGroupUpdate("standard-sockets")));
            updates.add(HostServerUpdate.create((String)"example-server", (AbstractModelUpdate)new ServerElementSocketBindingPortOffsetUpdate(350)));
            List results = client.applyHostUpdates(serverManagerName, updates);
            HostUpdateResult result = (HostUpdateResult)results.get(0);
            System.out.println("Add success: " + result.isSuccess());
            if (result.isSuccess()) {
                System.out.println("Starting server example-server");
                ServerStatus status2 = client.startServer(serverManagerName, "example-server");
                System.out.println("Start executed. Server status is " + status2);
                Thread.sleep(1000L);
                System.out.println("\nStopping server example-server");
                status2 = client.stopServer(serverManagerName, "example-server", -1L, TimeUnit.SECONDS);
                System.out.println("Stop executed. Server status is " + status2);
                System.out.println("Removing server example-server");
                updates = new ArrayList(1);
                updates.add(new HostServerRemove("example-server"));
                results = client.applyHostUpdates(serverManagerName, updates);
                result = (HostUpdateResult)results.get(0);
                System.out.println("Remove success: " + result.isSuccess());
            }
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(client);
            throw throwable;
        }
        StreamUtils.safeClose((Closeable)client);
    }

    private static String writeModel(String element, XMLContentWriter content) throws Exception, FactoryConfigurationError {
        XMLMapper mapper = XMLMapper.Factory.create();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(bos);
        try {
            mapper.deparseDocument((XMLContentWriter)new RootElementWriter(element, content), writer);
        }
        catch (XMLStreamException e) {
            System.out.println("XML Content that was written prior to exception:");
            System.out.println(writer.toString());
            throw e;
        }
        finally {
            writer.close();
            bos.close();
        }
        return new String(baos.toByteArray());
    }

    private static List<ServerIdentity> findUsefulServers(Map<ServerIdentity, ServerStatus> statuses, ServerStatus requiredStatus) {
        ServerIdentity a = null;
        ServerIdentity b = null;
        for (Map.Entry<ServerIdentity, ServerStatus> server : statuses.entrySet()) {
            ServerStatus status = server.getValue();
            if (status != requiredStatus) continue;
            ServerIdentity id = server.getKey();
            if (a == null) {
                a = id;
                continue;
            }
            if (b == null) {
                if ("other-server-group".equals(a.getServerGroupName())) {
                    b = id;
                    continue;
                }
                b = a;
                a = id;
                continue;
            }
            if (a.getHostName().equals(id.getHostName())) {
                if (b.getHostName().equals(id.getHostName())) {
                    if (!"other-server-group".equals(id.getServerGroupName())) continue;
                    b = id;
                    continue;
                }
                if (!"other-server-group".equals(id.getServerGroupName())) continue;
                a = id;
                continue;
            }
            if ("other-server-group".equals(id.getServerGroupName())) {
                b = a;
                a = id;
                continue;
            }
            b = id;
        }
        if (a == null) {
            throw new IllegalStateException("No started servers are available");
        }
        ArrayList<ServerIdentity> result = new ArrayList<ServerIdentity>();
        result.add(a);
        if (b != null) {
            result.add(b);
        }
        return result;
    }

    private static class RootElementWriter
    implements XMLContentWriter {
        private final String element;
        private final XMLContentWriter content;

        RootElementWriter(String element, XMLContentWriter content) {
            this.element = element;
            this.content = content;
        }

        public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
            streamWriter.writeStartDocument();
            streamWriter.writeStartElement(this.element);
            this.content.writeContent(streamWriter);
            streamWriter.writeEndDocument();
        }
    }
}

