/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.web.connector.runner;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.war.archive.SimpleServlet;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.AbstractSocketBindingUpdate;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ServerSocketBindingUpdate;
import org.jboss.as.model.ServerSubsystemUpdate;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.SocketBindingAdd;
import org.jboss.as.model.socket.SocketBindingRemove;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.standalone.client.api.StandaloneClient;
import org.jboss.as.standalone.client.api.StandaloneUpdateResult;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebConnectorRemove;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DeploymentUtils utils = null;
        StandaloneClient client = StandaloneClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
        try {
            utils = new DeploymentUtils();
            utils.addWarDeployment("war-example.war", SimpleServlet.class.getPackage(), true);
            utils.deploy();
            ExampleRunner.createTestConnector(client);
            URLConnection conn = null;
            BufferedInputStream in = null;
            try {
                URL url = new URL("http://localhost:8380/war-example/simple?input=Hello");
                System.out.println("Reading response from " + url + ":");
                conn = url.openConnection();
                conn.setDoInput(true);
                in = new BufferedInputStream(conn.getInputStream());
                int i = ((InputStream)in).read();
                while (i != -1) {
                    System.out.print((char)i);
                    i = ((InputStream)in).read();
                }
                System.out.println("");
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(in);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)in);
            ExampleRunner.removeTestConnector(client);
        }
        finally {
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
            StreamUtils.safeClose((Closeable)client);
        }
    }

    static void createTestConnector(StandaloneClient client) throws UpdateFailedException {
        SocketBindingAdd bindingUpdate = new SocketBindingAdd("default", "http-test", 8380);
        WebConnectorAdd connector = new WebConnectorAdd("testConnector");
        connector.setBindingRef("http-test");
        connector.setEnabled(Boolean.TRUE);
        connector.setProtocol("http");
        connector.setScheme("http");
        ArrayList updates = new ArrayList();
        updates.add((AbstractServerModelUpdate<?>)new ServerSocketBindingUpdate((AbstractSocketBindingUpdate)bindingUpdate));
        updates.add((AbstractServerModelUpdate<?>)ServerSubsystemUpdate.create((AbstractSubsystemUpdate)connector));
        ExampleRunner.applyUpdates(updates, client);
    }

    static void removeTestConnector(StandaloneClient client) throws UpdateFailedException {
        SocketBindingRemove bindingUpdate = new SocketBindingRemove("http-test");
        WebConnectorRemove connector = new WebConnectorRemove("testConnector");
        ArrayList updates = new ArrayList();
        updates.add((AbstractServerModelUpdate<?>)new ServerSocketBindingUpdate((AbstractSocketBindingUpdate)bindingUpdate));
        updates.add((AbstractServerModelUpdate<?>)ServerSubsystemUpdate.create((AbstractSubsystemUpdate)connector));
        ExampleRunner.applyUpdates(updates, client);
    }

    static void applyUpdates(List<AbstractServerModelUpdate<?>> updates, StandaloneClient client) throws UpdateFailedException {
        for (StandaloneUpdateResult result : client.applyUpdates(updates)) {
            if (result.isSuccess()) continue;
            throw result.getFailure();
        }
    }
}

