/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.client.messaging.runner;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import javax.resource.spi.IllegalStateException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String queueName = "queue.standalone";
        ClientSessionFactory sf = ExampleRunner.createClientSessionFactory("localhost", 5445);
        ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
        try {
            if (ExampleRunner.queueExists("queue.standalone", sf)) {
                throw new IllegalStateException();
            }
            ModelNode op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "messaging");
            op.get("address").add("queue", "queue.standalone");
            op.get("queue-address").set("queue.standalone");
            ExampleRunner.applyUpdate(op, client);
            if (!ExampleRunner.queueExists("queue.standalone", sf)) {
                throw new IllegalStateException();
            }
            ClientSession session = null;
            try {
                session = sf.createSession();
                ClientProducer producer = session.createProducer("queue.standalone");
                ClientMessage message = session.createMessage(false);
                String propName = "myprop";
                message.putStringProperty("myprop", "Hello sent at " + new Date());
                System.out.println("Sending the message.");
                producer.send((Message)message);
                ClientConsumer messageConsumer = session.createConsumer("queue.standalone");
                session.start();
                ClientMessage messageReceived = messageConsumer.receive(1000L);
                System.out.println("Received TextMessage:" + messageReceived.getStringProperty("myprop"));
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
            op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", "messaging");
            op.get("address").add("queue", "queue.standalone");
            ExampleRunner.applyUpdate(op, client);
            if (ExampleRunner.queueExists("queue.standalone", sf)) {
                throw new IllegalStateException();
            }
        }
        finally {
            client.close();
        }
    }

    static void applyUpdate(ModelNode update, ModelControllerClient client) throws OperationFailedException, IOException {
        ModelNode result = client.execute(OperationBuilder.Factory.create((ModelNode)update).build());
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("result")) {
                System.out.println(result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            throw new RuntimeException("Operation not successful; outcome = " + result.get("outcome"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean queueExists(String queueName, ClientSessionFactory sf) throws HornetQException {
        ClientSession session = sf.createSession(false, false, false);
        try {
            ClientSession.QueueQuery query = session.queueQuery(new SimpleString(queueName));
            boolean bl = query.isExists();
            return bl;
        }
        finally {
            session.close();
        }
    }

    static ClientSessionFactory createClientSessionFactory(String host, int port) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("host", host);
        properties.put("port", port);
        TransportConfiguration configuration = new TransportConfiguration(NettyConnectorFactory.class.getName(), properties);
        return HornetQClient.createClientSessionFactory((TransportConfiguration)configuration);
    }
}

