/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.domain.ds.runner;

import java.io.Closeable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.NameNotFoundException;
import org.jboss.as.demos.DomainDeploymentUtils;
import org.jboss.as.demos.ds.mbean.Test;
import org.jboss.as.protocol.StreamUtils;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DomainDeploymentUtils utils = null;
        try {
            utils = new DomainDeploymentUtils("ds-mbean.sar", Test.class.getPackage());
            utils.deploy();
            ObjectName objectName = new ObjectName("jboss:name=test,type=ds");
            MBeanServerConnection mbeanServer = utils.getServerOneConnection();
            System.out.println("Calling TestMBean.test() on server one");
            String s = (String)mbeanServer.invoke(objectName, "test", new Object[0], new String[0]);
            System.out.println("Received reply: " + s);
            mbeanServer = utils.getServerTwoConnection();
            System.out.println("Calling TestMBean.test() on server two");
            s = (String)mbeanServer.invoke(objectName, "test", new Object[0], new String[0]);
            System.out.println("Received reply: " + s);
        }
        catch (Exception e) {
            for (Throwable parent = e; parent != null; parent = parent.getCause()) {
                if (!(parent instanceof NameNotFoundException) || e.getMessage().indexOf("H2DS") <= -1) continue;
                ExampleRunner.usage(parent);
                return;
            }
            e.printStackTrace();
        }
        finally {
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
        }
    }

    private static void usage(Throwable t) throws Exception {
        System.out.println("Caught " + t.toString());
        System.out.println("Please make sure your domain.xml includes the H2DS datasource in its <profile name=\"default\"> element.");
        System.out.println("An example configuration is as follows:\n");
        System.out.println("<subsystem xmlns=\"urn:jboss:domain:datasources:1.0\">");
        System.out.println("    <datasources>");
        System.out.println("        <datasource jndi-name=\"java:/H2DS\" enabled=\"true\" use-java-context=\"true\" pool-name=\"H2DS\">");
        System.out.println("            <connection-url>jdbc:h2:mem:test;DB_CLOSE_DELAY=-1</connection-url>");
        System.out.println("            <driver-class>org.h2.Driver</driver-class>");
        System.out.println("            <module>com.h2database.h2</module>");
        System.out.println("            <pool></pool>");
        System.out.println("            <security>");
        System.out.println("                <user-name>sa</user-name>");
        System.out.println("                <password>sa</password>");
        System.out.println("            </security>");
        System.out.println("            <validation></validation>");
        System.out.println("            <time-out></time-out>");
        System.out.println("            <statement></statement>");
        System.out.println("        </datasource>");
        System.out.println("    </datasources>");
        System.out.println("</subsystem>");
        System.out.println("\nIf your profile already includes other datasource configurations, just add the nested <datasource> element above next to them.");
    }
}

