/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.domain.host.runner;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
        try {
            new ExampleRunner().run(client);
        }
        finally {
            StreamUtils.safeClose((Closeable)client);
        }
    }

    protected void run(ModelControllerClient client) throws Exception {
        this.runSysProperties(client);
        this.runPaths(client);
        this.runInterface(client);
    }

    void runSysProperties(ModelControllerClient client) throws Exception {
        ModelNode address = new ModelNode();
        address.add("host", "local");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add-system-property");
        operation.get("address").set(address);
        operation.get("name").set("test-property");
        operation.get("value").set("test-value");
        this.runOperationAndRollback(operation, client);
    }

    void runPaths(ModelControllerClient client) throws Exception {
        ModelNode address = new ModelNode();
        address.add("host", "local");
        address.add("path", "temp");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("name").set("temp");
        operation.get("path").set("temp");
        this.runOperationAndRollback(operation, client);
    }

    void runInterface(ModelControllerClient client) throws IOException {
        ModelNode address = new ModelNode();
        address.add("host", "local");
        address.add("interface", "new");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("name").set("new");
        operation.get("criteria").set("any-address");
        this.runOperationAndRollback(operation, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runOperationAndRollback(ModelNode operation, ModelControllerClient client) throws IOException {
        System.out.println("Executing operation:\n" + operation);
        ModelNode result = client.execute(operation);
        try {
            this.checkSuccess(result);
            ModelNode readResource = new ModelNode();
            readResource.get("operation").set("read-resource");
            readResource.get("address").set(operation.require("address"));
            ModelNode readResult = client.execute(readResource);
            this.checkSuccess(readResult);
            System.out.println("Effect on resource is \n" + readResult.get("result"));
        }
        finally {
            ModelNode compensating = result.get("compensating-operation");
            System.out.println("Reverting change via \n" + compensating);
            this.checkSuccess(client.execute(compensating));
        }
    }

    void checkSuccess(ModelNode result) {
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            return;
        }
        System.out.println("Outcome was not successful:\n" + result);
        if (result.hasDefined("failure-description")) {
            throw new RuntimeException(result.get("failure-description").toString());
        }
        if (result.hasDefined("domain-failure-description")) {
            throw new RuntimeException(result.get("domain-failure-description").toString());
        }
        if (result.hasDefined("host-failure-descriptions")) {
            throw new RuntimeException(result.get("host-failure-descriptions").toString());
        }
        if (result.isDefined()) {
            System.out.println(result);
            throw new RuntimeException("Operation outcome is " + result.get("outcome").asString());
        }
        throw new IllegalStateException("Result is undefined");
    }
}

