/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.ejb3.runner;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.ejb3.archive.AsyncLocal;
import org.jboss.as.demos.ejb3.archive.SimpleSingletonLocal;
import org.jboss.as.demos.ejb3.archive.SimpleStatelessSessionBean;
import org.jboss.as.demos.ejb3.archive.SimpleStatelessSessionLocal;
import org.jboss.as.demos.ejb3.mbean.ExerciseBMT;
import org.jboss.as.demos.ejb3.mbean.ExerciseEchoService;
import org.jboss.as.demos.ejb3.mbean.ExercisePatClifton;
import org.jboss.as.demos.ejb3.mbean.ExerciseStateful;
import org.jboss.as.demos.ejb3.mbean.Test;
import org.jboss.as.demos.ejb3.mdb.PostmanPatMDB;
import org.jboss.as.demos.ejb3.rar.SimpleQueueResourceAdapter;
import org.jboss.as.demos.ejb3.runner.TestMBeanInvocationHandler;
import org.jboss.as.protocol.StreamUtils;

public class ExampleRunner {
    private static <T> T createProxy(MBeanServerConnection mbeanServer, String lookupName, Class<T> intf) {
        TestMBeanInvocationHandler handler = new TestMBeanInvocationHandler(mbeanServer, lookupName);
        Class[] interfaces = new Class[]{intf};
        return intf.cast(Proxy.newProxyInstance(intf.getClassLoader(), interfaces, (InvocationHandler)handler));
    }

    private static void exec(MBeanServerConnection server, Class<? extends Callable<?>> callableClass) throws Exception {
        String msg = (String)server.invoke(new ObjectName("jboss:name=ejb3-test,type=service"), "exec", new Object[]{callableClass}, new String[]{Class.class.getName()});
        System.out.println(msg);
    }

    private static void workOnSingletoBean(MBeanServerConnection server, String jndiName, int numThreads, int numTimes) throws Exception {
        int singletonBeanInstances = (Integer)server.invoke(new ObjectName("jboss:name=ejb3-test,type=service"), "lookupSingleton", new Object[]{jndiName, numThreads, numTimes}, new String[]{String.class.getName(), Integer.TYPE.getName(), Integer.TYPE.getName()});
        System.out.println("Number of singleton bean instances created is: " + singletonBeanInstances);
        int count = (Integer)server.invoke(new ObjectName("jboss:name=ejb3-test,type=service"), "invokeSingleton", new Object[]{jndiName, numThreads, numTimes}, new String[]{String.class.getName(), Integer.TYPE.getName(), Integer.TYPE.getName()});
        System.out.println("Count is: " + count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DeploymentUtils utils = new DeploymentUtils();
        try {
            utils.addDeployment("ejb3-rar.rar", SimpleQueueResourceAdapter.class.getPackage());
            utils.addDeployment("ejb3-mdb.jar", PostmanPatMDB.class.getPackage());
            utils.addDeployment("ejb3-example.jar", SimpleStatelessSessionBean.class.getPackage());
            utils.addDeployment("ejb3-mbean.sar", Test.class.getPackage());
            utils.deploy();
            MBeanServerConnection mbeanServer = utils.getConnection();
            SimpleStatelessSessionLocal bean = ExampleRunner.createProxy(mbeanServer, "java:global/ejb3-example/SimpleStatelessSessionBean!" + SimpleStatelessSessionLocal.class.getName(), SimpleStatelessSessionLocal.class);
            String msg = bean.echo("Hello world");
            System.out.println(msg);
            String result = (String)mbeanServer.invoke(new ObjectName("jboss:name=ejb3-test,type=service"), "callAsync", new Object[]{"java:global/ejb3-example/AsyncBean!" + AsyncLocal.class.getName(), "Hello World"}, new String[]{String.class.getName(), String.class.getName()});
            System.out.println(result);
            ExampleRunner.exec(mbeanServer, ExerciseStateful.class);
            String singletonBeanJndiName = "java:global/ejb3-example/SimpleSingletonBean!" + SimpleSingletonLocal.class.getName();
            ExampleRunner.workOnSingletoBean(mbeanServer, singletonBeanJndiName, 100, 10);
            ExampleRunner.exec(mbeanServer, ExerciseBMT.class);
            ExampleRunner.exec(mbeanServer, ExerciseEchoService.class);
            ExampleRunner.exec(mbeanServer, ExercisePatClifton.class);
        }
        finally {
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
        }
    }
}

