/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.jms.mbean;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.jboss.as.demos.jms.mbean.TestMBean;
import org.jboss.logging.Logger;

public class Test
implements TestMBean {
    static final Logger log = Logger.getLogger(Test.class);
    private QueueConnection conn;
    private Queue queue;
    private QueueSession session;
    private final List<String> receivedMessages = new ArrayList<String>();

    @Override
    public void start() throws Exception {
        InitialContext ctx = new InitialContext();
        QueueConnectionFactory qcf = (QueueConnectionFactory)ctx.lookup("java:/ConnectionFactory");
        this.conn = qcf.createQueueConnection();
        this.conn.start();
        this.queue = (Queue)ctx.lookup("queue/test");
        this.session = this.conn.createQueueSession(false, 1);
        QueueReceiver recv = this.session.createReceiver(this.queue);
        recv.setMessageListener((MessageListener)new ExampeMessageListener());
    }

    @Override
    public void stop() throws Exception {
        if (this.conn != null) {
            this.conn.stop();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(String txt) throws Exception {
        QueueSender send = null;
        try {
            send = this.session.createSender(this.queue);
            TextMessage tm = this.session.createTextMessage(txt);
            send.send((Message)tm);
            log.info((Object)("-----> sent text=" + tm.getText()));
        }
        finally {
            send.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> readMessages() {
        List<String> list = this.receivedMessages;
        synchronized (list) {
            ArrayList<String> list2 = new ArrayList<String>(this.receivedMessages);
            this.receivedMessages.clear();
            return list2;
        }
    }

    private class ExampeMessageListener
    implements MessageListener {
        private ExampeMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            TextMessage msg = (TextMessage)message;
            try {
                log.info((Object)("-----> on message: " + msg.getText()));
                List list = Test.this.receivedMessages;
                synchronized (list) {
                    Test.this.receivedMessages.add(msg.getText());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

