/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.jpa.archive;

import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceProperty;
import javax.persistence.TransactionRequiredException;
import org.jboss.as.demos.jpa.archive.SimpleEntity;
import org.jboss.as.demos.jpa.archive.SimpleStatefulSessionLocal;

@Stateful
public class SimpleStatefulSessionBean
implements SimpleStatefulSessionLocal {
    private String state;
    @PersistenceContext(type=PersistenceContextType.EXTENDED, unitName="H2DS", properties={@PersistenceProperty(name="hibernate.hbm2ddl.auto", value="create-drop")})
    private EntityManager entityManager;

    @Override
    public String echo(String msg) {
        System.out.println("Called echo on " + this);
        System.out.println("call the entity manager");
        SimpleEntity entity = new SimpleEntity();
        entity.setId(1);
        entity.setName("Douglas Adams");
        this.entityManager.persist((Object)entity);
        System.out.println("saved new Entity for " + entity.getName());
        entity = (SimpleEntity)this.entityManager.find(SimpleEntity.class, (Object)new Integer(1));
        System.out.println("read back Entity for " + entity.getName());
        return "Echo " + msg + ":" + this.state + " entitymanager find should return 'Douglas Adams', it returned = " + entity;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public String echoNoTx(String msg) {
        System.out.println("Called echo on " + this);
        System.out.println("call the entity manager");
        SimpleEntity entity = new SimpleEntity();
        entity.setId(2);
        entity.setName("Douglas Adams");
        Throwable throwable = null;
        try {
            this.entityManager.persist((Object)entity);
        }
        catch (Exception expected) {
            throwable = expected;
        }
        while (throwable != null && !(throwable instanceof TransactionRequiredException)) {
            throwable = throwable.getCause();
        }
        if (throwable != null) {
            return "echoNoTx succeeded, got expected TransactionRequiredException exception while trying to persist without a transaction active";
        }
        return "echoNoTx failed, attempting to persist an entity should of thrown a TransactionRequiredException but didn't";
    }

    @Override
    public void setState(String s) {
        System.out.println("Called setState on " + this);
        this.state = s;
    }

    @Override
    public String getState() {
        return this.state;
    }
}

