/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.messaging.mbean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.jboss.as.demos.messaging.mbean.TestMBean;
import org.jboss.logging.Logger;

public class Test
implements TestMBean {
    private static final String QUEUE_EXAMPLE_QUEUE = "queue.exampleQueue";
    static final Logger log = Logger.getLogger(Test.class);
    private static final String BODY = "msg.body";
    private ClientSessionFactory sf;
    private ClientSession session;
    private ClientConsumer consumer;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final List<String> receivedMessages = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.sf = HornetQClient.createClientSessionFactory((TransportConfiguration)new TransportConfiguration(InVMConnectorFactory.class.getName()));
            ClientSession coreSession = this.sf.createSession(false, true, true);
            coreSession.createQueue(QUEUE_EXAMPLE_QUEUE, QUEUE_EXAMPLE_QUEUE, true);
            coreSession.close();
            this.session = this.sf.createSession();
            this.consumer = this.session.createConsumer(QUEUE_EXAMPLE_QUEUE);
            this.session.start();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!Test.this.shutdown.get()) {
                        try {
                            ClientMessage message = Test.this.consumer.receive(500L);
                            if (message == null) continue;
                            String s = message.getStringProperty(Test.BODY);
                            log.info((Object)("-----> Received: " + s));
                            List list = Test.this.receivedMessages;
                            synchronized (list) {
                                Test.this.receivedMessages.add(s);
                            }
                        }
                        catch (HornetQException e) {
                            log.error((Object)"Exception, closing receiver", (Throwable)e);
                        }
                    }
                }
            }).start();
            System.out.println("-----> Started queue and session");
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public void stop() throws Exception {
        this.shutdown.set(true);
        if (this.session != null) {
            this.session.close();
        }
        ClientSession coreSession = this.sf.createSession(false, false, false);
        coreSession.deleteQueue(QUEUE_EXAMPLE_QUEUE);
        coreSession.close();
    }

    @Override
    public void sendMessage(String txt) throws Exception {
        System.out.println("-----> Attempting to send message");
        ClientProducer producer = this.session.createProducer(QUEUE_EXAMPLE_QUEUE);
        ClientMessage message = this.session.createMessage(false);
        message.putStringProperty(BODY, "'" + txt + "' sent at " + new Date());
        System.out.println("-----> Sending message");
        producer.send((Message)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> readMessages(String txt) {
        List<String> list = this.receivedMessages;
        synchronized (list) {
            ArrayList<String> list2 = new ArrayList<String>(this.receivedMessages);
            this.receivedMessages.clear();
            return list2;
        }
    }
}

