/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.List;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;

public class PersistenceUnitSearch {
    public static String resolvePersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        int i;
        int n = i = persistenceUnitName == null ? -1 : persistenceUnitName.indexOf(35);
        if (i != -1) {
            String path = persistenceUnitName.substring(0, i);
            PersistenceUnitMetadata pu = PersistenceUnitSearch.getPersistenceUnit(deploymentUnit, path);
            return pu.getScopedPersistenceUnitName();
        }
        String name = PersistenceUnitSearch.findPersistenceUnitSupplier(deploymentUnit, persistenceUnitName);
        if (name == null) {
            throw new IllegalArgumentException("Can't find a persistence unit named '" + persistenceUnitName + "' in " + deploymentUnit);
        }
        return name;
    }

    private static String findPersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        String name = PersistenceUnitSearch.findWithinModule(deploymentUnit, persistenceUnitName, true);
        if (name == null) {
            name = PersistenceUnitSearch.findWithinApplication(PersistenceUnitSearch.getTopLevel(deploymentUnit), persistenceUnitName);
        }
        return name;
    }

    private static String findWithinApplication(DeploymentUnit unit, String persistenceUnitName) {
        String name = PersistenceUnitSearch.findWithinModule(unit, persistenceUnitName, false);
        if (name != null) {
            return name;
        }
        List resourceRoots = unit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            name = PersistenceUnitSearch.findWithinApplication(resourceRoot, persistenceUnitName);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private static String findWithinApplication(ResourceRoot moduleResourceRoot, String persistenceUnitName) {
        String name = PersistenceUnitSearch.findWithinModule(moduleResourceRoot, persistenceUnitName, false);
        if (name != null) {
            return name;
        }
        List resourceRoots = moduleResourceRoot.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            name = PersistenceUnitSearch.findWithinApplication(resourceRoot, persistenceUnitName);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private static String findWithinModule(ResourceRoot moduleResourceRoot, String persistenceUnitName, boolean allowScoped) {
        if (!allowScoped && PersistenceUnitSearch.isScoped(moduleResourceRoot)) {
            return null;
        }
        ResourceRoot deploymentRoot = moduleResourceRoot;
        PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
        if (holder == null || holder.getPersistenceUnits() == null) {
            return null;
        }
        for (PersistenceUnitMetadata persistenceUnit : holder.getPersistenceUnits()) {
            if (persistenceUnitName != null && persistenceUnitName.length() != 0 && !persistenceUnit.getPersistenceUnitName().equals(persistenceUnitName)) continue;
            return persistenceUnit.getScopedPersistenceUnitName();
        }
        return null;
    }

    private static String findWithinModule(DeploymentUnit unit, String persistenceUnitName, boolean allowScoped) {
        if (!allowScoped && PersistenceUnitSearch.isScoped(unit)) {
            return null;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
        if (holder == null || holder.getPersistenceUnits() == null) {
            return null;
        }
        for (PersistenceUnitMetadata persistenceUnit : holder.getPersistenceUnits()) {
            if (persistenceUnitName != null && persistenceUnitName.length() != 0 && !persistenceUnit.getPersistenceUnitName().equals(persistenceUnitName)) continue;
            return persistenceUnit.getScopedPersistenceUnitName();
        }
        return null;
    }

    private static boolean isScoped(DeploymentUnit unit) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)unit) || DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit);
    }

    private static boolean isScoped(ResourceRoot moduleResourceRoot) {
        return moduleResourceRoot.getRoot().getLowerCaseName().endsWith(".ear") || moduleResourceRoot.getRoot().getLowerCaseName().endsWith(".war");
    }

    private static DeploymentUnit getTopLevel(DeploymentUnit du) {
        while (du.getParent() != null) {
            du = du.getParent();
        }
        return du;
    }

    private static PersistenceUnitMetadata getPersistenceUnit(DeploymentUnit current, String path) {
        if (path.startsWith("/")) {
            return PersistenceUnitSearch.getPersistenceUnit(PersistenceUnitSearch.getTopLevel(current), path.substring(1));
        }
        if (path.startsWith("./")) {
            return PersistenceUnitSearch.getPersistenceUnit(current, path.substring(2));
        }
        if (path.startsWith("../")) {
            return PersistenceUnitSearch.getPersistenceUnit(current.getParent(), path.substring(3));
        }
        int i = path.indexOf(47);
        String name = i == -1 ? path : path.substring(0, i);
        List resourceRoots = current.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
            if (holder == null) continue;
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                if (!pu.getPersistenceUnitName().equals(name)) continue;
                return pu;
            }
        }
        throw new IllegalArgumentException("Can't find a deployment unit named " + name + " at " + current);
    }
}

