/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderAdapterRegistry;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class PersistenceUnitService
implements Service<PersistenceUnitService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jpa", "persistenceunit"});
    private final InjectedValue<Map> properties = new InjectedValue();
    private final InjectedValue<DataSource> jtaDataSource = new InjectedValue();
    private final InjectedValue<DataSource> nonJtaDataSource = new InjectedValue();
    private EntityManagerFactory entityManagerFactory;
    private PersistenceUnitMetadata pu;
    private static ConcurrentHashMap<String, PersistenceUnitService> persistenceServiceBackdoor = new ConcurrentHashMap();
    private static final SetContextLoaderAction CLEAR_ACTION = new SetContextLoaderAction(null);

    public PersistenceUnitService(PersistenceUnitMetadata pu, ResourceRoot resourceRoot) {
        this.pu = pu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        try {
            PersistenceProvider provider = this.lookupProvider(this.pu.getPersistenceProviderClassName());
            this.pu.setJtaDataSource((DataSource)this.jtaDataSource.getOptionalValue());
            this.pu.setNonJtaDataSource((DataSource)this.nonJtaDataSource.getOptionalValue());
            this.entityManagerFactory = this.createContainerEntityManagerFactory(provider);
            PersistenceUnitService.register(this);
        }
        finally {
            this.pu.setTempClassloader(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        try {
            if (this.entityManagerFactory != null) {
                this.entityManagerFactory.close();
                this.entityManagerFactory = null;
            }
        }
        finally {
            PersistenceUnitService.unregister(this);
        }
    }

    public PersistenceUnitService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EntityManager createEntityManager(String scopedPersistenceUnitName) {
        return this.entityManagerFactory.createEntityManager((Map)this.properties.getValue());
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    private String createScopedName(String appName, DeploymentUnit deploymentUnit, Module module, String persistenceUnitName) {
        assert (persistenceUnitName.indexOf(47) == -1);
        assert (persistenceUnitName.indexOf(35) == -1);
        String modulePath = "";
        String unitName = (appName != null ? appName + "/" : "") + modulePath + "#" + persistenceUnitName;
        return "persistence.unit:unitName=" + unitName;
    }

    public String resolvePersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        return PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, persistenceUnitName);
    }

    public Injector<Map> getPropertiesInjector() {
        return this.properties;
    }

    public Injector<DataSource> getJtaDataSourceInjector() {
        return this.jtaDataSource;
    }

    public Injector<DataSource> getNonJtaDataSourceInjector() {
        return this.nonJtaDataSource;
    }

    public static ServiceName getPUServiceName(PersistenceUnitMetadata pu) {
        return SERVICE_NAME.append(new String[]{pu.getScopedPersistenceUnitName()});
    }

    public static ServiceName getPUServiceName(String scopedPersistenceUnitName) {
        return SERVICE_NAME.append(new String[]{scopedPersistenceUnitName});
    }

    public static PersistenceUnitService getPersistenceUnitService(String scopedPersistenceUnitName) {
        return persistenceServiceBackdoor.get(scopedPersistenceUnitName);
    }

    private static void register(PersistenceUnitService service) {
        if (persistenceServiceBackdoor.containsKey(service.pu.getScopedPersistenceUnitName())) {
            throw new RuntimeException("Persistence Unit is already registered: " + service.pu.getScopedPersistenceUnitName());
        }
        persistenceServiceBackdoor.put(service.pu.getScopedPersistenceUnitName(), service);
    }

    private static void unregister(PersistenceUnitService service) {
        String name = service.pu.getScopedPersistenceUnitName();
        PersistenceUnitService removedValue = persistenceServiceBackdoor.remove(name);
        if (removedValue == null) {
            throw new RuntimeException("Could not remove Persistence Unit Service" + name);
        }
    }

    private PersistenceProvider lookupProvider(String providerName) {
        List providers = PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders();
        for (PersistenceProvider provider : providers) {
            if (!provider.getClass().getName().equals(providerName)) continue;
            return provider;
        }
        StringBuilder sb = new StringBuilder();
        for (PersistenceProvider provider : providers) {
            sb.append(provider.getClass().getName()).append(", ");
        }
        throw new PersistenceException("PersistenceProvider '" + providerName + "' not found in {" + sb.toString() + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory createContainerEntityManagerFactory(PersistenceProvider provider) {
        PersistenceProviderAdaptor adaptor = PersistenceProviderAdapterRegistry.getPersistenceProviderAdaptor(this.pu.getPersistenceProviderClassName());
        adaptor.beforeCreateContainerEntityManagerFactory(this.pu);
        AccessController.doPrivileged(new SetContextLoaderAction(TransactionManagerService.class.getClassLoader()));
        try {
            EntityManagerFactory entityManagerFactory = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.pu, (Map)this.properties.getValue());
            return entityManagerFactory;
        }
        finally {
            try {
                AccessController.doPrivileged(CLEAR_ACTION);
            }
            finally {
                try {
                    adaptor.afterCreateContainerEntityManagerFactory(this.pu);
                }
                finally {
                    this.pu.setAnnotationIndex(null);
                    this.pu.setTempClassloader(null);
                }
            }
        }
    }

    private static class SetContextLoaderAction
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        public SetContextLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }
}

