/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.transaction;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.jpa.container.EntityManagerMetadata;
import org.jboss.as.jpa.container.EntityManagerUtil;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;

public class TransactionUtil {
    private static final String[] TxStatusStrings = new String[]{"STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK"};
    private static final TransactionUtil INSTANCE = new TransactionUtil();
    private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");
    private static volatile TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private static volatile TransactionManager transactionManager;

    public static TransactionUtil getInstance() {
        return INSTANCE;
    }

    public static void setTransactionManager(TransactionManager tm) {
        if (transactionManager == null) {
            transactionManager = tm;
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        if (TransactionUtil.transactionSynchronizationRegistry == null) {
            TransactionUtil.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        }
    }

    public Transaction getTransaction() {
        try {
            return transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("An error occured while getting the transaction associated with the current thread: " + (Object)((Object)e));
        }
    }

    public static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return transactionSynchronizationRegistry;
    }

    public boolean isInTx() {
        Transaction tx = this.getTransaction();
        return tx != null && TxUtils.isActive((Transaction)tx);
    }

    private static String currentThread() {
        return Thread.currentThread().getName();
    }

    private static String getEntityManagerDetails(EntityManager manager) {
        String result = TransactionUtil.currentThread() + ":";
        try {
            EntityManagerMetadata metadata = (EntityManagerMetadata)manager.unwrap(EntityManagerMetadata.class);
            if (metadata != null) {
                result = result + metadata.getPuName() + (metadata.isTransactionScopedEntityManager() ? " [XPC]" : " [transactional]");
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        return result;
    }

    public void registerExtendedWithTransaction(String scopedPuName, EntityManager pc) {
        pc.joinTransaction();
        this.setPC(scopedPuName, pc);
    }

    private EntityManager getPC(String scopedPuName) {
        return (EntityManager)TransactionUtil.getTransactionSynchronizationRegistry().getResource((Object)scopedPuName);
    }

    private void setPC(String scopedPuName, EntityManager entityManager) {
        TransactionUtil.getTransactionSynchronizationRegistry().putResource((Object)scopedPuName, (Object)entityManager);
    }

    public void verifyInTx() {
        Transaction tx = this.getTransaction();
        if (tx == null || !TxUtils.isActive((Transaction)tx)) {
            throw new TransactionRequiredException("EntityManager must be access within a transaction");
        }
        if (!TxUtils.isActive((Transaction)tx)) {
            throw new TransactionRequiredException("Transaction must be active to access EntityManager");
        }
    }

    public EntityManager getTransactionScopedEntityManager(String puScopedName) {
        return this.getPC(puScopedName);
    }

    public EntityManager getOrCreateTransactionScopedEntityManager(EntityManagerFactory emf, String puScopedName, Map properties) {
        EntityManager rtnSession = this.getPC(puScopedName);
        if (rtnSession == null) {
            rtnSession = EntityManagerUtil.createEntityManager(emf, properties);
            Transaction tx = this.getTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)(TransactionUtil.getEntityManagerDetails(rtnSession) + ": created entity managersession " + tx.toString()));
            }
            try {
                tx.registerSynchronization((Synchronization)new SessionSynchronization(rtnSession, tx, true, puScopedName));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            this.setPC(puScopedName, rtnSession);
            rtnSession.joinTransaction();
        } else if (log.isDebugEnabled()) {
            Transaction tx = this.getTransaction();
            log.debug((Object)(TransactionUtil.getEntityManagerDetails(rtnSession) + ": reuse entity managersession already in tx" + tx.toString()));
        }
        return rtnSession;
    }

    public static boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return TransactionUtil.isActive(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isActive(TransactionManager tm) {
        try {
            return TransactionUtil.isActive(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isActive() {
        return TransactionUtil.isActive(TransactionUtil.getTransactionManager());
    }

    public static boolean isActive(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return TransactionUtil.isActive(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isActive(int status) {
        return status == 0;
    }

    public static boolean isUncommitted(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return TransactionUtil.isUncommitted(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isUncommitted(TransactionManager tm) {
        try {
            return TransactionUtil.isUncommitted(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isUncommitted() {
        return TransactionUtil.isUncommitted(TransactionUtil.getTransactionManager());
    }

    public static boolean isUncommitted(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return TransactionUtil.isUncommitted(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isUncommitted(int status) {
        return status == 0 || status == 1;
    }

    public static boolean isCompleted(Transaction tx) {
        if (tx == null) {
            return true;
        }
        try {
            int status = tx.getStatus();
            return TransactionUtil.isCompleted(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isCompleted(TransactionManager tm) {
        try {
            return TransactionUtil.isCompleted(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isCompleted() {
        return TransactionUtil.isCompleted(TransactionUtil.getTransactionManager());
    }

    public static boolean isCompleted(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return TransactionUtil.isCompleted(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isCompleted(int status) {
        return status == 3 || status == 4 || status == 6;
    }

    public static boolean isRollback(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return TransactionUtil.isRollback(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isRollback(TransactionManager tm) {
        try {
            return TransactionUtil.isRollback(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isRollback() {
        return TransactionUtil.isRollback();
    }

    public static boolean isRollback(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return TransactionUtil.isRollback(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isRollback(int status) {
        return status == 1 || status == 9 || status == 4;
    }

    public static String getStatusAsString(int status) {
        if (status >= 0 && status <= 9) {
            return TxStatusStrings[status];
        }
        return "STATUS_INVALID(" + status + ")";
    }

    public static String getXAResourceFlagsAsString(int flags) {
        if (flags == 0) {
            return "|TMNOFLAGS";
        }
        StringBuffer sbuf = new StringBuffer(64);
        if ((flags & 0x40000000) != 0) {
            sbuf.append("|TMONEPHASE");
        }
        if ((flags & 0x200000) != 0) {
            sbuf.append("|TMJOIN");
        }
        if ((flags & 0x8000000) != 0) {
            sbuf.append("|TMRESUME");
        }
        if ((flags & 0x4000000) != 0) {
            sbuf.append("|TMSUCCESS");
        }
        if ((flags & 0x20000000) != 0) {
            sbuf.append("|TMFAIL");
        }
        if ((flags & 0x2000000) != 0) {
            sbuf.append("|TMSUSPEND");
        }
        if ((flags & 0x1000000) != 0) {
            sbuf.append("|TMSTARTRSCAN");
        }
        if ((flags & 0x800000) != 0) {
            sbuf.append("|TMENDRSCAN");
        }
        return sbuf.toString();
    }

    public static String getXAErrorCodeAsString(int errorCode) {
        switch (errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "XA_UNKNOWN(" + errorCode + ")";
    }

    private static class SessionSynchronization
    implements Synchronization {
        private EntityManager manager;
        private boolean closeAtTxCompletion;
        private String scopedPuName;

        public SessionSynchronization(EntityManager session, Transaction tx, boolean close, String scopedPuName) {
            this.manager = session;
            this.closeAtTxCompletion = close;
            this.scopedPuName = scopedPuName;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (this.closeAtTxCompletion) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(TransactionUtil.getEntityManagerDetails(this.manager) + ": closing entity managersession "));
                }
                this.manager.close();
            }
        }
    }
}

