/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ejb.packaging.NamedInputStream;
import org.hibernate.ejb.packaging.Scanner;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.hibernate.HibernatePatternFilter;
import org.jboss.as.jpa.hibernate.HibernateVirtualFileNamedInputStream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class HibernateAnnotationScanner
implements Scanner {
    private static ThreadLocal<PersistenceUnitMetadata> persistenceUnitMetadataTLS = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };

    public static void setThreadLocalPersistenceUnitMetadata(PersistenceUnitMetadata pu) {
        persistenceUnitMetadataTLS.set(pu);
    }

    public static void clearThreadLocalPersistenceUnitMetadata() {
        persistenceUnitMetadataTLS.set(null);
    }

    public Set<Package> getPackagesInJar(URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        Set<Object> resultClasses = new HashSet();
        if (annotationsToLookFor.size() > 0) {
            resultClasses = this.getClassesInJar(jartoScan, annotationsToLookFor);
        } else {
            PersistenceUnitMetadata pu = persistenceUnitMetadataTLS.get();
            if (pu == null) {
                throw new RuntimeException("Missing PersistenceUnitMetadata (thread local wasn't set)");
            }
            Index index = pu.getAnnotationIndex();
            if (index == null) {
                throw new RuntimeException("Missing annotation index to scan entity classes");
            }
            if (jartoScan == null) {
                throw new IllegalArgumentException("Null jar to scan url");
            }
            Collection collection = index.getKnownClasses();
            for (ClassInfo classInfo : collection) {
                String className = classInfo.name().toString();
                try {
                    resultClasses.add(pu.getClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not load entity class '" + className + "' with PersistenceUnitInfo.getNewTempClassLoader()", e);
                }
            }
        }
        HashMap<String, Package> uniquePackages = new HashMap<String, Package>();
        for (Class clazz : resultClasses) {
            Package classPackage = clazz.getPackage();
            if (classPackage == null) continue;
            uniquePackages.put(classPackage.getName(), classPackage);
        }
        return new HashSet<Package>(uniquePackages.values());
    }

    public Set<Class<?>> getClassesInJar(URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        PersistenceUnitMetadata pu = persistenceUnitMetadataTLS.get();
        if (pu == null) {
            throw new RuntimeException("Missing PersistenceUnitMetadata (thread local wasn't set)");
        }
        Index index = pu.getAnnotationIndex();
        if (index == null) {
            throw new RuntimeException("Missing annotation index to scan entity classes");
        }
        if (jartoScan == null) {
            throw new IllegalArgumentException("Null jar to scan url");
        }
        if (annotationsToLookFor == null) {
            throw new IllegalArgumentException("Null annotations to look for");
        }
        if (annotationsToLookFor.size() == 0) {
            throw new IllegalArgumentException("Zero annotations to look for");
        }
        HashSet result = new HashSet();
        for (Class<? extends Annotation> annClass : annotationsToLookFor) {
            DotName annotation = DotName.createSimple((String)annClass.getName());
            List classesWithAnnotation = index.getAnnotations(annotation);
            for (AnnotationInstance annotationInstance : classesWithAnnotation) {
                String className = annotationInstance.target().toString();
                try {
                    result.add(pu.getClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not load entity class '" + className + "' with PersistenceUnitInfo.getNewTempClassLoader()", e);
                }
            }
        }
        return result;
    }

    public Set<NamedInputStream> getFilesInJar(URL jartoScan, Set<String> filePatterns) {
        if (jartoScan == null) {
            throw new IllegalArgumentException("Null jar to scan url");
        }
        if (filePatterns == null) {
            throw new IllegalArgumentException("Null file patterns to look for");
        }
        HashSet<NamedInputStream> result = new HashSet<NamedInputStream>();
        HashMap<String, Set<NamedInputStream>> map = new HashMap<String, Set<NamedInputStream>>();
        this.findFiles(jartoScan, filePatterns, map, result);
        return result;
    }

    private void findFiles(URL jartoScan, Set<String> filePatterns, Map<String, Set<NamedInputStream>> map, Set<NamedInputStream> result) {
        if (filePatterns.isEmpty()) {
            for (Set<NamedInputStream> nims : map.values()) {
                result.addAll(nims);
            }
        } else {
            VirtualFile root = null;
            for (String pattern : filePatterns) {
                Set<NamedInputStream> niss = map.get(pattern);
                if (niss == null) {
                    if (root == null) {
                        root = this.getFile(jartoScan);
                    }
                    try {
                        List children = root.getChildrenRecursively((VirtualFileFilter)new HibernatePatternFilter(pattern));
                        niss = this.toNIS(children);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (niss == null) continue;
                result.addAll(niss);
            }
        }
    }

    private Set<NamedInputStream> toNIS(Iterable<VirtualFile> files) {
        HashSet<NamedInputStream> result = new HashSet<NamedInputStream>();
        for (VirtualFile file : files) {
            HibernateVirtualFileNamedInputStream nis = new HibernateVirtualFileNamedInputStream(file);
            result.add(nis);
        }
        return result;
    }

    public Set<NamedInputStream> getFilesInClasspath(Set<String> filePatterns) {
        throw new RuntimeException("Not yet implemented");
    }

    public String getUnqualifiedJarName(URL jarUrl) {
        VirtualFile file = this.getFile(jarUrl);
        return file.getName();
    }

    private VirtualFile getFile(URL url) {
        try {
            return VFS.getChild((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

