/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnit;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.injectors.PersistenceContextBindingSourceDescription;
import org.jboss.as.jpa.injectors.PersistenceUnitBindingSourceDescription;
import org.jboss.as.jpa.interceptor.SBInvocationInterceptorFactory;
import org.jboss.as.jpa.interceptor.SFSBCreateInterceptorFactory;
import org.jboss.as.jpa.interceptor.SFSBDestroyInterceptorFactory;
import org.jboss.as.jpa.interceptor.SFSBInvocationInterceptorFactory;
import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.msc.service.ServiceName;

public class JPAAnnotationParseProcessor
extends AbstractComponentConfigProcessor {
    private static final DotName PERSISTENCE_CONTEXT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceContext.class.getName());
    private static final DotName PERSISTENCE_UNIT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceUnit.class.getName());
    private static final String ENTITY_MANAGER_CLASS = "javax.persistence.EntityManager";
    private static final String ENTITY_MANAGERFACTORY_CLASS = "javax.persistence.EntityManagerFactory";

    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex compositeIndex, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo classInfo = compositeIndex.getClassByName(DotName.createSimple((String)componentDescription.getComponentClassName()));
        if (classInfo == null) {
            return;
        }
        componentDescription.addAnnotationBindings(this.getConfigurations(deploymentUnit, classInfo, componentDescription, phaseContext));
        Collection interceptorConfigurations = componentDescription.getAllInterceptors().values();
        for (InterceptorDescription interceptorConfiguration : interceptorConfigurations) {
            ClassInfo interceptorClassInfo = compositeIndex.getClassByName(DotName.createSimple((String)interceptorConfiguration.getInterceptorClassName()));
            if (interceptorClassInfo == null) continue;
            componentDescription.addAnnotationBindings(this.getConfigurations(deploymentUnit, interceptorClassInfo, componentDescription, phaseContext));
        }
    }

    private List<BindingDescription> getConfigurations(DeploymentUnit deploymentUnit, ClassInfo classInfo, AbstractComponentDescription componentDescription, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ArrayList<BindingDescription> configurations = new ArrayList<BindingDescription>();
        boolean isJPADeploymentMarker = false;
        Map classAnnotations = classInfo.annotations();
        if (classAnnotations != null) {
            List resourceAnnotations = (List)classAnnotations.get(PERSISTENCE_UNIT_ANNOTATION_NAME);
            if (resourceAnnotations != null && resourceAnnotations.size() > 0) {
                isJPADeploymentMarker = true;
                for (AnnotationInstance annotation : resourceAnnotations) {
                    configurations.add(this.getConfiguration(deploymentUnit, annotation, componentDescription, phaseContext));
                }
            }
            if ((resourceAnnotations = (List)classAnnotations.get(PERSISTENCE_CONTEXT_ANNOTATION_NAME)) != null && resourceAnnotations.size() > 0) {
                isJPADeploymentMarker = true;
                for (AnnotationInstance annotation : resourceAnnotations) {
                    configurations.add(this.getConfiguration(deploymentUnit, annotation, componentDescription, phaseContext));
                }
            }
        }
        if (isJPADeploymentMarker) {
            JPADeploymentMarker.mark(deploymentUnit);
        }
        return configurations;
    }

    private BindingDescription getConfiguration(DeploymentUnit deploymentUnit, AnnotationInstance annotation, AbstractComponentDescription componentDescription, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        AnnotationTarget annotationTarget = annotation.target();
        this.registerInterceptors(componentDescription, annotation);
        BindingDescription resourceConfiguration = annotationTarget instanceof FieldInfo ? this.processField(deploymentUnit, annotation, (FieldInfo)FieldInfo.class.cast(annotationTarget), componentDescription, phaseContext) : (annotationTarget instanceof MethodInfo ? this.processMethod(deploymentUnit, annotation, (MethodInfo)MethodInfo.class.cast(annotationTarget), componentDescription, phaseContext) : (annotationTarget instanceof ClassInfo ? this.processClassResource(deploymentUnit, annotation, (ClassInfo)ClassInfo.class.cast(annotationTarget), componentDescription, phaseContext) : null));
        return resourceConfiguration;
    }

    private BindingDescription processField(DeploymentUnit deploymentUnit, AnnotationInstance annotation, FieldInfo fieldInfo, AbstractComponentDescription componentDescription, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String fieldName = fieldInfo.name();
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? fieldName : declaredName;
        DotName declaredType = fieldInfo.type().name();
        DotName injectionType = declaredType == null || declaredType.toString().equals(Object.class.getName()) ? fieldInfo.type().name() : declaredType;
        BindingDescription bindingDescription = new BindingDescription(localContextName, componentDescription);
        bindingDescription.setDependency(true);
        String injectionTypeName = injectionType.toString();
        bindingDescription.setBindingType(injectionTypeName);
        bindingDescription.setReferenceSourceDescription(this.getBindingSource(deploymentUnit, annotation, injectionTypeName));
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(fieldName);
        targetDescription.setClassName(fieldInfo.declaringClass().name().toString());
        targetDescription.setType(InjectionTargetDescription.Type.FIELD);
        targetDescription.setDeclaredValueClassName(fieldInfo.type().name().toString());
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private BindingDescription processMethod(DeploymentUnit deploymentUnit, AnnotationInstance annotation, MethodInfo methodInfo, AbstractComponentDescription componentDescription, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : declaredName;
        DotName declaredType = methodInfo.returnType().name();
        DotName injectionType = declaredType == null || declaredType.toString().equals(Object.class.getName()) ? methodInfo.returnType().name() : declaredType;
        BindingDescription bindingDescription = new BindingDescription(localContextName, componentDescription);
        bindingDescription.setDependency(true);
        String injectionTypeName = injectionType.toString();
        bindingDescription.setBindingType(injectionTypeName);
        bindingDescription.setReferenceSourceDescription(this.getBindingSource(deploymentUnit, annotation, injectionTypeName));
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(methodName);
        targetDescription.setClassName(methodInfo.declaringClass().name().toString());
        targetDescription.setType(InjectionTargetDescription.Type.METHOD);
        targetDescription.setDeclaredValueClassName(methodInfo.returnType().name().toString());
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private BindingDescription processClassResource(DeploymentUnit deploymentUnit, AnnotationInstance annotation, ClassInfo classInfo, AbstractComponentDescription componentDescription, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        AnnotationValue nameValue = annotation.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw new IllegalArgumentException("Class level annotations must provide a name.");
        }
        String name = nameValue.asString();
        BindingDescription bindingDescription = new BindingDescription(name, componentDescription);
        bindingDescription.setDependency(true);
        String type = this.getClassLevelInjectionType(annotation);
        bindingDescription.setBindingType(type);
        bindingDescription.setReferenceSourceDescription(this.getBindingSource(deploymentUnit, annotation, type));
        return bindingDescription;
    }

    private BindingSourceDescription getBindingSource(DeploymentUnit deploymentUnit, AnnotationInstance annotation, String injectionTypeName) throws DeploymentUnitProcessingException {
        String scopedPuName = this.getScopedPuName(deploymentUnit, annotation);
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        if (this.isPersistenceContext(annotation)) {
            HashMap<AnnotationValue, AnnotationValue> properties;
            AnnotationInstance[] props;
            AnnotationValue pcType = annotation.value("type");
            PersistenceContextType type = pcType == null || PersistenceContextType.TRANSACTION.name().equals(pcType.asString()) ? PersistenceContextType.TRANSACTION : PersistenceContextType.EXTENDED;
            AnnotationValue value = annotation.value("properties");
            AnnotationInstance[] annotationInstanceArray = props = value != null ? value.asNestedArray() : null;
            if (props != null) {
                properties = new HashMap<AnnotationValue, AnnotationValue>();
                for (int source = 0; source < props.length; ++source) {
                    properties.put(props[source].value("name"), props[source].value("value"));
                }
            } else {
                properties = null;
            }
            return new PersistenceContextBindingSourceDescription(type, properties, puServiceName, deploymentUnit, scopedPuName, injectionTypeName);
        }
        return new PersistenceUnitBindingSourceDescription(puServiceName, deploymentUnit, scopedPuName, injectionTypeName);
    }

    private boolean isExtendedPersistenceContext(AnnotationInstance annotation) {
        AnnotationValue value = annotation.value("type");
        return annotation.name().local().equals("PersistenceContext") && value != null && PersistenceContextType.EXTENDED.name().equals(value.asString());
    }

    private boolean isPersistenceContext(AnnotationInstance annotation) {
        return annotation.name().local().equals("PersistenceContext");
    }

    private String getClassLevelInjectionType(AnnotationInstance annotation) {
        boolean isPC = annotation.name().local().equals("PersistenceContext");
        return isPC ? ENTITY_MANAGER_CLASS : ENTITY_MANAGERFACTORY_CLASS;
    }

    private String getScopedPuName(DeploymentUnit deploymentUnit, AnnotationInstance annotation) throws DeploymentUnitProcessingException {
        String scopedPuName;
        AnnotationValue puName = annotation.value("unitName");
        String searchName = null;
        if (puName != null) {
            searchName = puName.asString();
        }
        if (null == (scopedPuName = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, searchName))) {
            throw new DeploymentUnitProcessingException("Can't find a deployment unit named " + puName.asString() + " at " + deploymentUnit);
        }
        return scopedPuName;
    }

    private ServiceName getPuServiceName(String scopedPuName) throws DeploymentUnitProcessingException {
        return PersistenceUnitService.getPUServiceName(scopedPuName);
    }

    private void registerInterceptors(AbstractComponentDescription componentDescription, AnnotationInstance annotation) {
        if (componentDescription instanceof StatefulComponentDescription && this.isExtendedPersistenceContext(annotation)) {
            componentDescription.addPostConstructInterceptorFactory((InterceptorFactory)new SFSBCreateInterceptorFactory());
            componentDescription.addPreDestroyInterceptorFactory((InterceptorFactory)new SFSBDestroyInterceptorFactory());
            componentDescription.addInterceptorFactory((InterceptorFactory)SFSBInvocationInterceptorFactory.getInstance());
        }
        if (!this.isExtendedPersistenceContext(annotation) && (componentDescription instanceof StatefulComponentDescription || componentDescription instanceof StatelessComponentDescription)) {
            componentDescription.addInterceptorFactory((InterceptorFactory)SBInvocationInterceptorFactory.getInstance());
        }
    }
}

