/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.jpa.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JPADescriptions {
    static final String RESOURCE_NAME = JPADescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private JPADescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ModelNode subsystem = new ModelNode();
        ResourceBundle bundle = JPADescriptions.getResourceBundle(locale);
        subsystem.get("description").set(bundle.getString("jpa"));
        subsystem.get("head-comment-allowed").set(true);
        subsystem.get("tail-comment-allowed").set(true);
        subsystem.get("namespace").set(Namespace.JPA_1_0.getUriString());
        subsystem.get(new String[]{"attributes", "default-datasource", "description"}).set(bundle.getString("default.datasource"));
        subsystem.get(new String[]{"attributes", "default-datasource", "type"}).set(ModelType.STRING);
        subsystem.get(new String[]{"attributes", "default-datasource", "required"}).set(true);
        subsystem.get(new String[]{"attributes", "default-datasource", "min-length"}).set(0);
        subsystem.get("operations");
        subsystem.get("children");
        return subsystem;
    }

    static ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle = JPADescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle.getString("jpa.add"));
        op.get(new String[]{"request-properties", "default-datasource", "description"}).set(bundle.getString("default.datasource"));
        op.get(new String[]{"request-properties", "default-datasource", "type"}).set(ModelType.STRING);
        op.get(new String[]{"request-properties", "default-datasource", "required"}).set(true);
        op.get(new String[]{"request-properties", "default-datasource", "min-length"}).set(0);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getSubsystemRemove(Locale locale) {
        ResourceBundle bundle = JPADescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("jpa.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

