/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.as.jpa.config.PersistenceProviderDeploymentHolder;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class PersistenceProviderProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.jpa");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            ModuleClassLoader deploymentModuleClassLoader = module.getClassLoader();
            PersistenceProvider provider = null;
            List providerNames = servicesAttachment.getServiceImplementations(PersistenceProvider.class.getName());
            if (providerNames.size() > 1) {
                throw new DeploymentUnitProcessingException("only one persistence provider can be packaged with an application " + providerNames);
            }
            for (String providerName : providerNames) {
                try {
                    Class<PersistenceProvider> providerClass = deploymentModuleClassLoader.loadClass(providerName).asSubclass(PersistenceProvider.class);
                    Constructor<PersistenceProvider> constructor = providerClass.getConstructor(new Class[0]);
                    provider = constructor.newInstance(new Object[0]);
                    log.infof("Deployment has its own Persistence Provider %s ", providerClass);
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException("Could not deploy application packaged persistence provider '" + providerName + "'", (Throwable)e);
                }
            }
            if (provider != null) {
                String adapterClass = (String)deploymentUnit.getAttachment(JpaAttachments.ADAPTOR_CLASS_NAME);
                PersistenceProviderAdaptor adaptor = null;
                if (adapterClass != null) {
                    try {
                        adaptor = (PersistenceProviderAdaptor)deploymentModuleClassLoader.loadClass(adapterClass).newInstance();
                        adaptor.injectJtaManager(JtaManagerImpl.getInstance());
                    }
                    catch (InstantiationException e) {
                        throw new DeploymentUnitProcessingException("could not create instance of adapter class '" + adapterClass + "'", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new DeploymentUnitProcessingException("could not create instance of adapter class '" + adapterClass + "'", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentUnitProcessingException("could not create instance of adapter class '" + adapterClass + "'", (Throwable)e);
                    }
                }
                deploymentUnit.putAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER, (Object)new PersistenceProviderDeploymentHolder(provider, adaptor));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

