/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.persistenceprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.persistenceprovider.SecurityActions;
import org.jboss.modules.ModuleClassLoader;

public class PersistenceProviderResolverImpl
implements PersistenceProviderResolver {
    private Map<ClassLoader, List<Class>> persistenceProviderPerClassLoader = new HashMap<ClassLoader, List<Class>>();
    private List<Class> providers = new CopyOnWriteArrayList<Class>();
    private static final PersistenceProviderResolverImpl INSTANCE = new PersistenceProviderResolverImpl();

    public static PersistenceProviderResolverImpl getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersistenceProvider> getPersistenceProviders() {
        ArrayList<PersistenceProvider> providersCopy = new ArrayList<PersistenceProvider>(this.providers.size());
        Map<ClassLoader, List<Class>> map = this.persistenceProviderPerClassLoader;
        synchronized (map) {
            ClassLoader deploymentClassLoader;
            List<Class> deploymentSpecificPersistenceProviders;
            if (this.persistenceProviderPerClassLoader.size() > 0 && (deploymentSpecificPersistenceProviders = this.persistenceProviderPerClassLoader.get(deploymentClassLoader = this.findParentModuleCl(SecurityActions.getContextClassLoader()))) != null) {
                for (Class providerClass : deploymentSpecificPersistenceProviders) {
                    try {
                        JpaLogger.ROOT_LOGGER.tracef("application has its own Persistence Provider %s", (Object)providerClass.getName());
                        providersCopy.add((PersistenceProvider)providerClass.newInstance());
                    }
                    catch (InstantiationException e) {
                        throw JpaMessages.MESSAGES.couldNotCreateInstanceProvider((Throwable)e, providerClass.getName());
                    }
                    catch (IllegalAccessException e) {
                        throw JpaMessages.MESSAGES.couldNotCreateInstanceProvider((Throwable)e, providerClass.getName());
                    }
                }
            }
        }
        for (Class providerClass : this.providers) {
            try {
                providersCopy.add((PersistenceProvider)providerClass.newInstance());
                JpaLogger.ROOT_LOGGER.tracef("returning global (module) Persistence Provider %s", (Object)providerClass.getName());
            }
            catch (InstantiationException e) {
                throw JpaMessages.MESSAGES.couldNotCreateInstanceProvider((Throwable)e, providerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw JpaMessages.MESSAGES.couldNotCreateInstanceProvider((Throwable)e, providerClass.getName());
            }
        }
        return providersCopy;
    }

    public void clearCachedProviders() {
        this.providers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedDeploymentSpecificProviders(Set<ClassLoader> deploymentClassLoaders) {
        Map<ClassLoader, List<Class>> map = this.persistenceProviderPerClassLoader;
        synchronized (map) {
            for (ClassLoader deploymentClassLoader : deploymentClassLoaders) {
                this.persistenceProviderPerClassLoader.remove(deploymentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeploymentSpecificPersistenceProvider(PersistenceProvider persistenceProvider, Set<ClassLoader> deploymentClassLoaders) {
        Map<ClassLoader, List<Class>> map = this.persistenceProviderPerClassLoader;
        synchronized (map) {
            for (ClassLoader deploymentClassLoader : deploymentClassLoaders) {
                List<Class> list = this.persistenceProviderPerClassLoader.get(deploymentClassLoader);
                if (list == null) {
                    list = new ArrayList<Class>();
                    this.persistenceProviderPerClassLoader.put(deploymentClassLoader, list);
                }
                list.add(persistenceProvider.getClass());
            }
        }
    }

    private ClassLoader findParentModuleCl(ClassLoader classLoader) {
        ClassLoader c;
        for (c = classLoader; c != null && !(c instanceof ModuleClassLoader); c = c.getParent()) {
        }
        return c;
    }

    public void addPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.providers.add(persistenceProvider.getClass());
    }
}

