/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.config;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.jboss.bpm.api.config.ConfigurationProvider;
import org.jboss.bpm.api.service.ProcessEngine;

public final class Configuration {
    private static ConfigurationProvider provider;

    private Configuration() {
    }

    public static ProcessEngine getProcessEngine() {
        return Configuration.getConfigurationProvider().getProcessEngine();
    }

    public static ProcessEngine getProcessEngine(String engineName) {
        return Configuration.getConfigurationProvider().getProcessEngine(engineName);
    }

    public static ConfigurationProvider getConfigurationProvider() {
        if (provider == null) {
            ClassLoader ctxLoader;
            String providerName = System.getProperty(ConfigurationProvider.class.getName());
            if (providerName == null) {
                ctxLoader = Thread.currentThread().getContextClassLoader();
                URL providerURL = ctxLoader.getResource(ConfigurationProvider.class.getName());
                if (providerURL == null) {
                    throw new IllegalStateException("Cannot find resource: " + ConfigurationProvider.class.getName());
                }
                try {
                    providerName = new BufferedReader(new InputStreamReader(providerURL.openStream())).readLine();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot read configuration provider name from: " + providerURL);
                }
            }
            if (providerName == null) {
                throw new IllegalStateException("Cannot obtain configuration provider");
            }
            try {
                ctxLoader = Thread.currentThread().getContextClassLoader();
                Class<?> providerClass = ctxLoader.loadClass(providerName);
                provider = (ConfigurationProvider)providerClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot load configuration provider: " + providerName);
            }
        }
        return provider;
    }
}

