/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.config.internal;

import java.net.URL;
import org.jboss.bpm.api.config.internal.KernelLocator;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedBeansDeployer
extends BasicBootstrap {
    final Logger log = LoggerFactory.getLogger(EmbeddedBeansDeployer.class);
    private Kernel kernel = KernelLocator.getKernel();
    private BasicXMLDeployer deployer;

    public EmbeddedBeansDeployer() {
        if (this.kernel == null) {
            try {
                this.kernel = super.getKernel();
                this.log.debug("bootstrap kernel: " + this.kernel);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Cannot bootstrap kernel", e);
            }
        }
        this.deployer = new BasicXMLDeployer(this.kernel);
    }

    public void deploy(URL url) {
        this.log.debug("deploy: " + url);
        try {
            this.deployer.deploy(url);
            this.deployer.validate();
            if (KernelLocator.getKernel() == null) {
                throw new IllegalStateException("KernelLocator not deployed as MC bean");
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot deploy beans from: " + url, e);
        }
    }

    public void undeploy(URL url) {
        this.log.debug("undeploy: " + url);
        try {
            this.deployer.undeploy(url);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot undeploy beans from: " + url, e);
        }
    }
}

