/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.bpm.api.config.Configuration;
import org.jboss.bpm.api.model.Message;
import org.jboss.bpm.api.model.MessageListener;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.Participant;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessInstanceService;
import org.jboss.bpm.api.service.internal.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageService
extends AbstractService {
    final Logger log = LoggerFactory.getLogger(MessageService.class);
    private Map<ObjectName, MessageListener> listeners = new HashMap<ObjectName, MessageListener>();

    public static MessageService locateMessageService() {
        ProcessEngine engine = Configuration.getProcessEngine();
        return engine.getService(MessageService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(MessageListener listener) {
        Map<ObjectName, MessageListener> map = this.listeners;
        synchronized (map) {
            if (this.hasMessageListener(listener.getKey())) {
                throw new IllegalStateException("Listener already registered: " + listener.getKey());
            }
            this.log.debug("addMessageListener: " + listener.getKey());
            this.listeners.put(listener.getKey(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageListener> getMessageListeners() {
        Map<ObjectName, MessageListener> map = this.listeners;
        synchronized (map) {
            HashSet<MessageListener> set = new HashSet<MessageListener>(this.listeners.values());
            return Collections.unmodifiableSet(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageListener getMessageListener(ObjectName listenerID) {
        Map<ObjectName, MessageListener> map = this.listeners;
        synchronized (map) {
            return this.listeners.get(listenerID);
        }
    }

    public boolean hasMessageListener(ObjectName listenerID) {
        return this.getMessageListener(listenerID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(ObjectName listenerID) {
        Map<ObjectName, MessageListener> map = this.listeners;
        synchronized (map) {
            this.log.debug("removeMessageListener: " + listenerID);
            this.listeners.remove(listenerID);
        }
    }

    public void sendMessage(ObjectName procID, String targetName, Message msg) {
        ProcessInstanceService procService = this.getProcessEngine().getService(ProcessInstanceService.class);
        ProcessInstance proc = procService.getInstance(procID);
        if (proc == null) {
            throw new IllegalStateException("Cannot obtain registered process: " + procID);
        }
        Node targetNode = proc.getNode(targetName);
        if (targetNode == null) {
            throw new IllegalArgumentException("Cannot find message target: " + targetName);
        }
        if (!(targetNode instanceof MessageListener)) {
            throw new IllegalArgumentException("Message target is not a valid message receiver: " + targetName);
        }
        this.log.debug("sendMessage to " + targetNode + " => " + msg);
        MessageListener msgListener = (MessageListener)((Object)targetNode);
        msgListener.catchMessage(msg);
    }

    public void sendMessage(Message msg) {
        Participant toRef = msg.getToRef();
        if (toRef == null) {
            throw new IllegalArgumentException("Target entity cannot be null");
        }
        MessageListener msgListener = this.getMessageListener(toRef.getName());
        if (msgListener == null) {
            throw new IllegalStateException("No message listener registered for: " + toRef);
        }
        this.log.debug("sendMessage to '" + toRef + "' => " + msg);
        msgListener.catchMessage(msg);
    }
}

