/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.test;

import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.bpm.api.model.ObjectNameFactory;
import org.jboss.bpm.api.test.APITestHelper;
import org.jboss.bpm.api.test.ArchiveDeployer;
import org.jboss.bpm.api.test.JBossArchiveDeployer;

public class IntegrationTestHelper
extends APITestHelper {
    private static MBeanServerConnection server;
    private String integrationTarget;

    public void deploy(String archive) throws Exception {
        URL url = this.getTestArchiveFile(archive).toURI().toURL();
        this.deploy(url);
    }

    public void deploy(URL archive) throws Exception {
        this.getDeployer().deploy(archive);
    }

    public void undeploy(String archive) throws Exception {
        URL url = this.getTestArchiveFile(archive).toURI().toURL();
        this.undeploy(url);
    }

    public void undeploy(URL archive) throws Exception {
        this.getDeployer().undeploy(archive);
    }

    public boolean isTargetJBoss500() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss500");
    }

    public boolean isTargetJBoss423() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss423");
    }

    public boolean isTargetJBoss422() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss422");
    }

    private String getIntegrationTarget() {
        if (this.integrationTarget == null) {
            String jbossVersion;
            try {
                ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
                jbossVersion = (String)this.getServer().getAttribute(oname, "SpecificationVersion");
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot obtain jboss version", ex);
            }
            if (jbossVersion.startsWith("5.0.0")) {
                this.integrationTarget = "jboss500";
            } else if (jbossVersion.startsWith("4.2.3")) {
                this.integrationTarget = "jboss423";
            } else if (jbossVersion.startsWith("4.2.2")) {
                this.integrationTarget = "jboss422";
            } else {
                throw new IllegalStateException("Unsupported jboss version: " + jbossVersion);
            }
        }
        return this.integrationTarget;
    }

    public MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> jndiEnv = null;
            try {
                InitialContext iniCtx = new InitialContext();
                jndiEnv = iniCtx.getEnvironment();
                server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
            }
        }
        return server;
    }

    private ArchiveDeployer getDeployer() {
        return new JBossArchiveDeployer(this.getServer());
    }
}

