/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins.loader;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Set;
import org.jboss.classloader.spi.Loader;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderToLoaderAdapter
implements Loader {
    private static final Logger log = Logger.getLogger(ClassLoaderToLoaderAdapter.class);
    private ClassLoader classLoader;
    private AccessControlContext accessControlContext;
    private static Method getPackage;
    private static Method getPackages;

    public ClassLoaderToLoaderAdapter(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classLoader");
        }
        this.classLoader = classLoader;
        this.accessControlContext = AccessController.getContext();
    }

    @Override
    public URL getResource(final String name) {
        SecurityManager sm = System.getSecurityManager();
        URL url = sm != null ? AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassLoaderToLoaderAdapter.this.classLoader.getResource(name);
            }
        }, this.accessControlContext) : this.classLoader.getResource(name);
        if (log.isTraceEnabled()) {
            if (url != null) {
                log.trace((Object)("Resource " + name + " found in " + this.classLoader));
            } else {
                log.trace((Object)("Resource " + name + " NOT found in " + this.classLoader));
            }
        }
        return url;
    }

    @Override
    public void getResources(final String name, Set<URL> urls) throws IOException {
        Enumeration<URL> enumeration;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                enumeration = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                    @Override
                    public Enumeration<URL> run() throws Exception {
                        return ClassLoaderToLoaderAdapter.this.classLoader.getResources(name);
                    }
                }, this.accessControlContext);
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                if (e1 instanceof RuntimeException) {
                    throw (RuntimeException)e1;
                }
                if (e1 instanceof IOException) {
                    throw (IOException)e1;
                }
                IOException e2 = new IOException("Unexpected error");
                e2.initCause(e1);
                throw e2;
            }
        } else {
            enumeration = this.classLoader.getResources(name);
        }
        while (enumeration.hasMoreElements()) {
            urls.add(enumeration.nextElement());
        }
    }

    @Override
    public Class<?> loadClass(String className) {
        try {
            return Class.forName(className, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Package getPackage(String name) {
        if (getPackage == null) {
            return null;
        }
        try {
            return (Package)getPackage.invoke((Object)this.classLoader, name);
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected error retrieving package " + name + " from classloader " + this.classLoader), (Throwable)e);
            return null;
        }
    }

    @Override
    public void getPackages(Set<Package> packages) {
        if (getPackages == null) {
            return;
        }
        try {
            getPackages.invoke((Object)this.classLoader, new Object[0]);
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected error retrieving packages from classloader " + this.classLoader), (Throwable)e);
        }
    }

    public String toString() {
        return this.classLoader.toString();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                    getPackage.setAccessible(true);
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to set accessible on ClassLoader.getPackage()", (Throwable)e);
                }
                try {
                    getPackages = ClassLoader.class.getDeclaredMethod("getPackages", new Class[0]);
                    getPackages.setAccessible(true);
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to set accessible on ClassLoader.getPackages()", (Throwable)e);
                }
                return null;
            }
        });
    }
}

