/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency.policy.mock;

import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockClassLoadingMetaData
extends ClassLoadingMetaData {
    private static final long serialVersionUID = 1L;
    private String prefix = "";
    private String[] paths;
    private String[] included;
    private String[] excluded;
    private String[] exported;

    public MockClassLoadingMetaData(String name) {
        this(name, Version.DEFAULT_VERSION);
    }

    public MockClassLoadingMetaData(String name, String version) {
        this.setName(name);
        this.setVersion(Version.parseVersion(version));
    }

    public MockClassLoadingMetaData(String name, Version version) {
        this.setName(name);
        this.setVersion(version);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setPath(String path) {
        this.setPaths(path);
    }

    public void setPaths(String ... paths) {
        this.paths = paths;
    }

    public void setPaths(Class<?> ... classes) {
        if (classes == null) {
            this.paths = null;
            return;
        }
        this.paths = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.paths[i] = ClassLoaderUtils.packageNameToPath((String)classes[i].getName());
        }
    }

    public String[] getExportedPackages() {
        return this.exported;
    }

    public void setExportedPackages(String ... packageNames) {
        this.exported = packageNames;
    }

    public void setExportedPackages(Class<?> ... classes) {
        if (classes == null) {
            this.exported = null;
            return;
        }
        this.exported = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.exported[i] = ClassLoaderUtils.getClassPackageName((String)classes[i].getName());
        }
    }

    public String[] getIncludedClasses() {
        return this.included;
    }

    public void setIncluded(String[] included) {
        this.included = included;
    }

    public String[] getExcludedClasses() {
        return this.excluded;
    }

    public void setExcluded(String[] excluded) {
        this.excluded = excluded;
    }

    public void setIncludedClasses(Class<?> ... classes) {
        if (classes == null) {
            this.included = null;
            return;
        }
        this.included = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.included[i] = ClassLoaderUtils.classNameToPath((String)classes[i].getName());
        }
    }

    public void setIncludedClasses(String ... included) {
        this.included = included;
    }

    public void setExcludedClasses(Class<?> ... classes) {
        if (classes == null) {
            this.excluded = null;
            return;
        }
        this.excluded = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.excluded[i] = ClassLoaderUtils.classNameToPath((String)classes[i].getName());
        }
    }

    public void setExcludedClasses(String ... excluded) {
        this.excluded = excluded;
    }

    public void setPathsAndPackageNames(Class<?> ... classes) {
        this.setPaths(classes);
        this.setExportedPackages(classes);
    }

    public void setPathsAndPackageNames(String ... packages) {
        if (packages == null) {
            this.paths = null;
            this.exported = null;
            return;
        }
        this.paths = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            this.paths[i] = packages[i].replace('.', '/');
        }
        this.setExportedPackages(packages);
    }
}

