/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Future;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.SessionID;
import org.jboss.logging.Logger;

public final class EJBClient {
    private static final Logger logger = Logger.getLogger(EJBClient.class);
    private static final ThreadLocal<Future<?>> FUTURE_RESULT = new ThreadLocal();

    private EJBClient() {
    }

    public static void createSession(Object proxy) {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException(proxy + " is not a known proxy");
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        if (!(invocationHandler instanceof EJBInvocationHandler)) {
            throw new IllegalArgumentException(proxy + " wasn't generated by " + EJBClient.class.getName());
        }
        EJBInvocationHandler ejbInvocationHandler = (EJBInvocationHandler)invocationHandler;
        EJBClientContext ejbClientContext = EJBClientContext.requireCurrent();
        String appName = ejbInvocationHandler.getAppName();
        String moduleName = ejbInvocationHandler.getModuleName();
        String distinctName = ejbInvocationHandler.getDistinctName();
        EJBReceiver<?> ejbReceiver = ejbClientContext.requireEJBReceiver(appName, moduleName, distinctName);
        try {
            SessionID sessionId = ejbReceiver.openSession(ejbClientContext.requireEJBReceiverContext(ejbReceiver), appName, moduleName, distinctName, ejbInvocationHandler.getBeanName());
            ejbInvocationHandler.putAttachment(SessionID.SESSION_ID_KEY, sessionId);
        }
        catch (Exception e) {
            logger.error((Object)("Error while generating session id for proxy " + proxy), (Throwable)e);
        }
    }

    public static <T> T asynchronous(T proxy) throws IllegalArgumentException {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        if (invocationHandler instanceof EJBInvocationHandler) {
            EJBInvocationHandler remoteInvocationHandler = (EJBInvocationHandler)invocationHandler;
            return proxy;
        }
        throw new IllegalArgumentException("Not a valid remote EJB proxy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> getFutureResult(T operation) throws IllegalStateException {
        if (operation != null) {
            throw new IllegalStateException("Operation wasn't asynchronous");
        }
        ThreadLocal<Future<?>> futureResult = FUTURE_RESULT;
        try {
            Future<?> future = futureResult.get();
            if (future == null) {
                throw new IllegalStateException("No asynchronous operation in progress");
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            futureResult.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<?> getFutureResult() throws IllegalStateException {
        ThreadLocal<Future<?>> futureResult = FUTURE_RESULT;
        try {
            Future<?> future = futureResult.get();
            if (future == null) {
                throw new IllegalStateException("No asynchronous operation in progress");
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            futureResult.remove();
        }
    }

    static void setFutureResult(Future<?> future) {
        FUTURE_RESULT.set(future);
    }

    public static <T> T getProxy(String appName, String moduleName, String distinctName, String beanName, Class<T> viewType) throws IllegalArgumentException {
        if (moduleName == null || moduleName.trim().isEmpty()) {
            throw new IllegalArgumentException("Module name cannot be null or empty");
        }
        if (beanName == null || beanName.trim().isEmpty()) {
            throw new IllegalArgumentException("Bean name cannot be null or empty");
        }
        if (viewType == null) {
            throw new IllegalArgumentException("Bean interface type cannot be null");
        }
        return viewType.cast(Proxy.newProxyInstance(viewType.getClassLoader(), new Class[]{viewType}, EJBClient.getInvocationHandler(viewType, appName, moduleName, distinctName, beanName)));
    }

    static InvocationHandler getInvocationHandler(Class<?> viewClass, String appName, String moduleName, String distinctName, String beanName) {
        return new EJBInvocationHandler(viewClass, appName, moduleName, distinctName, beanName);
    }
}

