/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;

public final class EJBClientInvocationContext<A>
extends Attachable {
    private final EJBInvocationHandler invocationHandler;
    private final EJBClientContext ejbClientContext;
    private final A receiverSpecific;
    private final EJBReceiver<A> receiver;
    private final Object invokedProxy;
    private final Method invokedMethod;
    private final EJBClientInterceptor<? super A>[] interceptorChain;
    private int idx;
    private boolean requestDone;
    private boolean resultDone;
    private Object[] parameters;
    private EJBReceiverInvocationContext.ResultProducer resultProducer;
    private final EJBReceiverInvocationContext receiverInvocationContext;
    private final FutureResponse futureResponse = new FutureResponse();

    EJBClientInvocationContext(EJBInvocationHandler invocationHandler, EJBClientContext ejbClientContext, A receiverSpecific, EJBReceiver<A> receiver, EJBReceiverContext ejbReceiverContext, Object invokedProxy, Method invokedMethod, Object[] parameters, EJBClientInterceptor<? super A>[] chain) {
        this.invocationHandler = invocationHandler;
        this.ejbClientContext = ejbClientContext;
        this.receiverSpecific = receiverSpecific;
        this.receiver = receiver;
        this.receiverInvocationContext = new EJBReceiverInvocationContext(this, ejbReceiverContext);
        this.invokedProxy = invokedProxy;
        this.invokedMethod = invokedMethod;
        this.parameters = parameters;
        this.interceptorChain = chain;
    }

    public <T> T getProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.getAttachment(key);
    }

    public <T> T removeProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.removeAttachment(key);
    }

    public <T> T getClientContextAttachment(AttachmentKey<T> key) {
        return this.ejbClientContext.getAttachment(key);
    }

    public <T> T getReceiverAttachment(AttachmentKey<T> key) {
        return this.receiver.getAttachment(key);
    }

    public <T> T putReceiverAttachment(AttachmentKey<T> key, T value) {
        return this.receiver.putAttachment(key, value);
    }

    public String getAppName() {
        return this.invocationHandler.getAppName();
    }

    public String getModuleName() {
        return this.invocationHandler.getModuleName();
    }

    public String getDistinctName() {
        return this.invocationHandler.getDistinctName();
    }

    public String getBeanName() {
        return this.invocationHandler.getBeanName();
    }

    public A getReceiverSpecific() {
        return this.receiverSpecific;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest() throws Exception {
        if (this.requestDone) {
            throw new IllegalStateException("sendRequest() called during wrong phase");
        }
        int idx = this.idx++;
        EJBClientInterceptor<? super A>[] chain = this.interceptorChain;
        try {
            if (chain.length == idx) {
                this.receiver.processInvocation(this, this.receiverInvocationContext);
            } else {
                chain[idx].handleInvocation(this);
            }
        }
        finally {
            this.requestDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResult() throws Exception {
        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
        if (this.resultDone || resultProducer == null) {
            throw new IllegalStateException("getResult() called during wrong phase");
        }
        int idx = this.idx++;
        EJBClientInterceptor<? super A>[] chain = this.interceptorChain;
        try {
            if (chain.length == idx) {
                Object object = resultProducer.getResult();
                return object;
            }
            Object object = chain[idx].handleInvocationResult(this);
            return object;
        }
        finally {
            this.resultDone = true;
        }
    }

    public void discardResult() throws IllegalStateException {
        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
        if (resultProducer == null) {
            throw new IllegalStateException("discardResult() called during request phase");
        }
        resultProducer.discardResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultReady(EJBReceiverInvocationContext.ResultProducer resultProducer) {
        FutureResponse futureResponse = this.futureResponse;
        synchronized (futureResponse) {
            this.idx = 0;
            this.resultProducer = resultProducer;
            this.futureResponse.notifyAll();
        }
    }

    void requestCancelled() {
    }

    protected EJBReceiver<A> getReceiver() {
        return this.receiver;
    }

    public Object getInvokedProxy() {
        return this.invokedProxy;
    }

    public Method getInvokedMethod() {
        return this.invokedMethod;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class<?> getViewClass() {
        return this.invocationHandler.getViewClass();
    }

    Future<?> getFutureResponse() {
        return this.futureResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object awaitResponse() throws Exception {
        boolean intr = false;
        try {
            Object object = this.futureResponse;
            synchronized (object) {
                while (this.resultProducer == null) {
                    try {
                        this.futureResponse.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
            object = this.getResult();
            return object;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    final class FutureResponse
    implements Future<Object> {
        private boolean cancelled;
        private boolean done;
        private Object result;
        private Throwable exception;

        FutureResponse() {
        }

        synchronized void cancelled() {
            this.cancelled = true;
            this.notifyAll();
        }

        synchronized void failed(Throwable exception) {
            this.done = true;
            this.exception = exception;
            this.notifyAll();
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public synchronized boolean isDone() {
            return this.done;
        }

        @Override
        public synchronized Object get() throws InterruptedException, ExecutionException {
            while (!this.done) {
                this.wait();
            }
            if (this.cancelled) {
                throw new CancellationException("Request was cancelled");
            }
            if (this.exception != null) {
                throw new ExecutionException("Remote execution failed", this.exception);
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.done) {
                long now = System.nanoTime();
                long end = Math.max(now, now + unit.toNanos(timeout));
                do {
                    if (EJBClientInvocationContext.this.resultProducer != null) {
                        try {
                            EJBClientInvocationContext.this.idx = 0;
                            Object object = this.result = EJBClientInvocationContext.this.getResult();
                            return object;
                        }
                        catch (Throwable e) {
                            this.exception = e;
                            break;
                        }
                        finally {
                            this.done = true;
                        }
                    }
                    long remaining = end - now;
                    if (remaining <= 0L) {
                        throw new TimeoutException("Timed out");
                    }
                    long millis = (remaining + 999999L) / 1000000L;
                    this.wait(millis);
                    now = System.nanoTime();
                } while (!this.done);
            }
            if (this.cancelled) {
                throw new CancellationException("Request was cancelled");
            }
            if (this.exception != null) {
                throw new ExecutionException("Remote execution failed", this.exception);
            }
            return this.result;
        }
    }
}

