/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import javax.transaction.xa.Xid;
import org.jboss.ejb.client.TransactionID;

public final class XidTransactionID
extends TransactionID
implements Xid {
    private static final long serialVersionUID = -1895745528459825578L;
    private final int formatId;
    private final byte gtidLen;

    XidTransactionID(byte[] encodedBytes) {
        super(encodedBytes);
        this.formatId = (encodedBytes[1] & 0xFF) << 24 | (encodedBytes[2] & 0xFF) << 16 | (encodedBytes[3] & 0xFF) << 8 | encodedBytes[4] & 0xFF;
        this.gtidLen = encodedBytes[5];
        if (this.gtidLen > 64) {
            throw new IllegalArgumentException("Invalid global transaction ID length");
        }
        byte bqalLen = encodedBytes[6 + this.gtidLen];
        if (bqalLen > 64 || bqalLen != encodedBytes.length - this.gtidLen - 6) {
            throw new IllegalArgumentException("Invalid branch qualifier length");
        }
    }

    XidTransactionID(Xid original) {
        this(XidTransactionID.encode(original));
    }

    private static byte[] encode(Xid original) {
        byte[] gtid = original.getGlobalTransactionId();
        byte[] bqal = original.getBranchQualifier();
        int formatId = original.getFormatId();
        byte[] target = new byte[gtid.length + bqal.length + 6];
        target[0] = (byte)(formatId >>> 24);
        target[1] = (byte)(formatId >>> 16);
        target[2] = (byte)(formatId >>> 8);
        target[3] = (byte)formatId;
        target[4] = (byte)gtid.length;
        System.arraycopy(gtid, 0, target, 5, gtid.length);
        target[6 + gtid.length] = (byte)bqal.length;
        System.arraycopy(bqal, 0, target, 7 + gtid.length, bqal.length);
        return target;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] target = new byte[this.gtidLen];
        System.arraycopy(this.getEncodedFormRaw(), 6, target, 0, this.gtidLen);
        return target;
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] raw = this.getEncodedFormRaw();
        byte[] target = new byte[raw.length - this.gtidLen - 6];
        System.arraycopy(raw, 6, target, 0, this.gtidLen);
        return target;
    }
}

