/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.remoting3.MessageInputStream;

class ModuleAvailabilityMessageHandler
extends ProtocolMessageHandler {
    private final RemotingConnectionEJBReceiver ejbReceiver;

    ModuleAvailabilityMessageHandler(RemotingConnectionEJBReceiver ejbReceiver) {
        this.ejbReceiver = ejbReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(MessageInputStream messageInputStream) throws IOException {
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from null stream");
        }
        try {
            DataInputStream input = new DataInputStream((InputStream)messageInputStream);
            int count = PackedInteger.readPackedInteger(input);
            EJBModuleIdentifier[] ejbModules = new EJBModuleIdentifier[count];
            for (int i = 0; i < ejbModules.length; ++i) {
                String appName = input.readUTF();
                if (appName.isEmpty()) {
                    appName = null;
                }
                String moduleName = input.readUTF();
                String distinctName = input.readUTF();
                if (distinctName.isEmpty()) {
                    distinctName = null;
                }
                ejbModules[i] = new EJBModuleIdentifier(appName, moduleName, distinctName);
            }
            for (EJBModuleIdentifier ejbModule : ejbModules) {
                this.ejbReceiver.onModuleAvailable(ejbModule.appName, ejbModule.moduleName, ejbModule.distinctName);
            }
        }
        finally {
            messageInputStream.close();
        }
    }

    private class EJBModuleIdentifier {
        private final String appName;
        private final String moduleName;
        private final String distinctName;

        EJBModuleIdentifier(String appname, String moduleName, String distinctName) {
            this.appName = appname;
            this.moduleName = moduleName;
            this.distinctName = distinctName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EJBModuleIdentifier that = (EJBModuleIdentifier)o;
            if (this.appName != null ? !this.appName.equals(that.appName) : that.appName != null) {
                return false;
            }
            if (this.distinctName != null ? !this.distinctName.equals(that.distinctName) : that.distinctName != null) {
                return false;
            }
            return this.moduleName.equals(that.moduleName);
        }

        public int hashCode() {
            int result = this.appName != null ? this.appName.hashCode() : 0;
            result = 31 * result + this.moduleName.hashCode();
            result = 31 * result + (this.distinctName != null ? this.distinctName.hashCode() : 0);
            return result;
        }
    }
}

