/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.remoting.AutoConnectionCloser;
import org.jboss.ejb.client.remoting.EJBClientContextConnectionReconnectHandler;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.NetworkUtil;
import org.jboss.ejb.client.remoting.RemotingCleanupHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class ConfigBasedEJBClientContextSelector
implements ContextSelector<EJBClientContext> {
    private static final Logger logger = Logger.getLogger(ConfigBasedEJBClientContextSelector.class);
    private final EJBClientConfiguration ejbClientConfiguration;
    private final EJBClientContext ejbClientContext;
    private final RemotingCleanupHandler remotingCleanupHandler = new RemotingCleanupHandler();

    public ConfigBasedEJBClientContextSelector(EJBClientConfiguration ejbClientConfiguration) {
        this.ejbClientConfiguration = ejbClientConfiguration;
        this.ejbClientContext = EJBClientContext.create(this.ejbClientConfiguration);
        this.ejbClientContext.registerEJBClientContextListener(this.remotingCleanupHandler);
        if (this.ejbClientConfiguration == null) {
            logger.debug((Object)("EJB client context " + this.ejbClientContext + " will have no EJB receivers associated with it since there was no " + "EJB client configuration available to create the receivers"));
            return;
        }
        try {
            this.setupEJBReceivers();
        }
        catch (IOException ioe) {
            logger.warn((Object)("EJB client context " + this.ejbClientContext + " will have no EJB receivers due to an error setting up EJB receivers"), (Throwable)ioe);
        }
    }

    @Override
    public EJBClientContext getCurrent() {
        return this.ejbClientContext;
    }

    private void setupEJBReceivers() throws IOException {
        if (!this.ejbClientConfiguration.getConnectionConfigurations().hasNext()) {
            return;
        }
        Endpoint endpoint = Remoting.createEndpoint((String)this.ejbClientConfiguration.getEndpointName(), (OptionMap)this.ejbClientConfiguration.getEndpointCreationOptions());
        this.trackEndpoint(endpoint);
        OptionMap remoteConnectionProviderOptions = this.ejbClientConfiguration.getRemoteConnectionProviderCreationOptions();
        endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), remoteConnectionProviderOptions);
        Iterator<EJBClientConfiguration.RemotingConnectionConfiguration> connectionConfigurations = this.ejbClientConfiguration.getConnectionConfigurations();
        ArrayList connections = new ArrayList();
        int successfulEJBReceiverRegistrations = 0;
        while (connectionConfigurations.hasNext()) {
            EJBClientContextConnectionReconnectHandler reconnectHandler = null;
            EJBClientConfiguration.RemotingConnectionConfiguration connectionConfiguration = connectionConfigurations.next();
            String host = connectionConfiguration.getHost();
            int port = connectionConfiguration.getPort();
            try {
                OptionMap connectionCreationOptions = connectionConfiguration.getConnectionCreationOptions();
                CallbackHandler callbackHandler = connectionConfiguration.getCallbackHandler();
                int MAX_RECONNECT_ATTEMPTS = 65535;
                reconnectHandler = new EJBClientContextConnectionReconnectHandler(this.ejbClientContext, endpoint, host, port, connectionCreationOptions, callbackHandler, connectionConfiguration.getChannelCreationOptions(), 65535, connectionConfiguration.getConnectionTimeout(), TimeUnit.MILLISECONDS);
                IoFuture<Connection> futureConnection = NetworkUtil.connect(endpoint, host, port, null, connectionCreationOptions, callbackHandler, null);
                Connection connection = IoFutureHelper.get(futureConnection, connectionConfiguration.getConnectionTimeout(), TimeUnit.MILLISECONDS);
                this.trackConnection(connection);
                RemotingConnectionEJBReceiver remotingEJBReceiver = new RemotingConnectionEJBReceiver(connection, reconnectHandler, connectionConfiguration.getChannelCreationOptions());
                this.ejbClientContext.registerEJBReceiver(remotingEJBReceiver);
                ++successfulEJBReceiverRegistrations;
            }
            catch (Exception e) {
                logger.warn((Object)("Could not register a EJB receiver for connection to " + host + ":" + port), (Throwable)e);
                if (reconnectHandler == null) continue;
                this.ejbClientContext.registerReconnectHandler(reconnectHandler);
                logger.debug((Object)("Registered a reconnect handler in EJB client context " + this.ejbClientContext + " for remote://" + host + ":" + port));
            }
        }
        logger.debug((Object)("Registered " + successfulEJBReceiverRegistrations + " remoting EJB receivers for EJB client context " + this.ejbClientContext));
    }

    private void trackEndpoint(Endpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        this.remotingCleanupHandler.addEndpoint(endpoint);
        AutoConnectionCloser.INSTANCE.addEndpoint(endpoint);
    }

    private void trackConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        this.remotingCleanupHandler.addConnection(connection);
        AutoConnectionCloser.INSTANCE.addConnection(connection);
    }
}

