/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.remoting.ConnectionPool;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;

class RemotingConnectionManager {
    private static final Logger logger = Logger.getLogger(RemotingConnectionManager.class);
    private final ConnectionPool connectionPool = ConnectionPool.INSTANCE;
    private final List<Connection> managedConnections = Collections.synchronizedList(new ArrayList());

    RemotingConnectionManager() {
    }

    Connection getConnection(Endpoint endpoint, String host, int port, EJBClientConfiguration.CommonConnectionCreationConfiguration connectionConfiguration) throws IOException {
        Connection connection = this.connectionPool.getConnection(endpoint, host, port, connectionConfiguration);
        this.trackConnection(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void safeClose() {
        List<Connection> list = this.managedConnections;
        synchronized (list) {
            for (Connection connection : this.managedConnections) {
                try {
                    connection.close();
                }
                catch (Throwable t) {
                    logger.debug((Object)("Failed to close " + connection), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAsync() {
        List<Connection> list = this.managedConnections;
        synchronized (list) {
            for (Connection connection : this.managedConnections) {
                connection.closeAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        List<Connection> list = this.managedConnections;
        synchronized (list) {
            for (Connection connection : this.managedConnections) {
                connection.close();
            }
        }
    }

    private void trackConnection(Connection connection) {
        this.managedConnections.add(connection);
    }
}

