/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.sasl.SaslException;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBClientContextListener;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.IdentityEJBClientContextSelector;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.remoting.EJBClientContextConnectionReconnectHandler;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.ejb.client.remoting.RemotingConnectionManager;
import org.jboss.ejb.client.remoting.RemotingEndpointManager;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;

public class ConfigBasedEJBClientContextSelector
implements IdentityEJBClientContextSelector {
    private static final Logger logger = Logger.getLogger(ConfigBasedEJBClientContextSelector.class);
    protected final EJBClientConfiguration ejbClientConfiguration;
    protected final EJBClientContext ejbClientContext;
    private final RemotingEndpointManager remotingEndpointManager = new RemotingEndpointManager();
    private final RemotingConnectionManager remotingConnectionManager = new RemotingConnectionManager();
    private final ConcurrentMap<EJBClientContextIdentifier, EJBClientContext> identifiableContexts = new ConcurrentHashMap<EJBClientContextIdentifier, EJBClientContext>();
    private volatile boolean receiversSetup;
    private static final boolean reconnectOnAuthenticationFailures = Boolean.valueOf(System.getProperty("jboss-ejb-client.reconnectOnAuthenticationFailures", "true"));

    public ConfigBasedEJBClientContextSelector(EJBClientConfiguration ejbClientConfiguration) {
        this(ejbClientConfiguration, null);
    }

    public ConfigBasedEJBClientContextSelector(EJBClientConfiguration ejbClientConfiguration, ClassLoader classLoader) {
        this.ejbClientConfiguration = ejbClientConfiguration;
        this.ejbClientContext = classLoader == null ? EJBClientContext.create(this.ejbClientConfiguration) : EJBClientContext.create(this.ejbClientConfiguration, classLoader);
        this.ejbClientContext.registerEJBClientContextListener(new ContextCloseListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EJBClientContext getCurrent() {
        if (this.receiversSetup) {
            return this.ejbClientContext;
        }
        ConfigBasedEJBClientContextSelector configBasedEJBClientContextSelector = this;
        synchronized (configBasedEJBClientContextSelector) {
            if (this.receiversSetup) {
                return this.ejbClientContext;
            }
            try {
                if (this.ejbClientConfiguration == null) {
                    logger.debugf("EJB client context %s will have no EJB receivers associated with it since there was no EJB client configuration available to create the receivers", (Object)this.ejbClientContext);
                    EJBClientContext eJBClientContext = this.ejbClientContext;
                    return eJBClientContext;
                }
                try {
                    this.setupEJBReceivers();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("EJB client context " + this.ejbClientContext + " will have no EJB receivers due to an error setting up EJB receivers"), (Throwable)ioe);
                }
            }
            finally {
                this.receiversSetup = true;
            }
            return this.ejbClientContext;
        }
    }

    private void setupEJBReceivers() throws IOException {
        if (!this.ejbClientConfiguration.getConnectionConfigurations().hasNext()) {
            return;
        }
        Endpoint endpoint = this.remotingEndpointManager.getEndpoint(this.ejbClientConfiguration.getEndpointName(), this.ejbClientConfiguration.getEndpointCreationOptions(), this.ejbClientConfiguration.getRemoteConnectionProviderCreationOptions());
        Iterator<EJBClientConfiguration.RemotingConnectionConfiguration> connectionConfigurations = this.ejbClientConfiguration.getConnectionConfigurations();
        int successfulEJBReceiverRegistrations = 0;
        while (connectionConfigurations.hasNext()) {
            EJBClientConfiguration.RemotingConnectionConfiguration connectionConfiguration = connectionConfigurations.next();
            String host = connectionConfiguration.getHost();
            String protocol = connectionConfiguration.getProtocol();
            int port = connectionConfiguration.getPort();
            int MAX_RECONNECT_ATTEMPTS = 65535;
            EJBClientContextConnectionReconnectHandler reconnectHandler = new EJBClientContextConnectionReconnectHandler(this.ejbClientContext, endpoint, protocol, host, port, connectionConfiguration, 65535);
            if (!connectionConfiguration.isConnectEagerly()) {
                this.ejbClientContext.registerReconnectHandler(reconnectHandler);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Connection to host: " + host + " and port: " + port + ", in EJB client context: " + this.ejbClientContext + ", is configured to be attempted lazily. Skipping connection creation for now"));
                continue;
            }
            try {
                Connection connection = this.remotingConnectionManager.getConnection(endpoint, protocol, host, port, connectionConfiguration);
                RemotingConnectionEJBReceiver remotingEJBReceiver = new RemotingConnectionEJBReceiver(connection, reconnectHandler, connectionConfiguration.getChannelCreationOptions(), protocol);
                this.ejbClientContext.registerEJBReceiver(remotingEJBReceiver);
                ++successfulEJBReceiverRegistrations;
            }
            catch (SaslException e) {
                logger.warn((Object)("Could not register a EJB receiver for connection to " + host + ":" + port), (Throwable)e);
                if (reconnectOnAuthenticationFailures) {
                    this.registerReconnectHandler(reconnectHandler, host, port);
                    continue;
                }
                logger.debug((Object)"Skipped registering a reconnect handler due to an authentication error!");
            }
            catch (Exception e) {
                logger.warn((Object)("Could not register a EJB receiver for connection to " + host + ":" + port), (Throwable)e);
                this.registerReconnectHandler(reconnectHandler, host, port);
            }
        }
        logger.debugf("Registered %s remoting EJB receivers for EJB client context %s", successfulEJBReceiverRegistrations, (Object)this.ejbClientContext);
    }

    private void registerReconnectHandler(ReconnectHandler reconnectHandler, String host, int port) {
        if (reconnectHandler != null) {
            this.ejbClientContext.registerReconnectHandler(reconnectHandler);
            logger.debug((Object)("Registered a reconnect handler in EJB client context " + this.ejbClientContext + " for remote://" + host + ":" + port));
        }
    }

    @Override
    public void registerContext(EJBClientContextIdentifier identifier, EJBClientContext context) {
        EJBClientContext previousRegisteredContext = this.identifiableContexts.putIfAbsent(identifier, context);
        if (previousRegisteredContext != null) {
            throw Logs.MAIN.ejbClientContextAlreadyRegisteredForIdentifier(identifier);
        }
    }

    @Override
    public EJBClientContext unRegisterContext(EJBClientContextIdentifier identifier) {
        return (EJBClientContext)this.identifiableContexts.remove(identifier);
    }

    @Override
    public EJBClientContext getContext(EJBClientContextIdentifier identifier) {
        return (EJBClientContext)this.identifiableContexts.get(identifier);
    }

    private class ContextCloseListener
    implements EJBClientContextListener {
        private ContextCloseListener() {
        }

        @Override
        public void contextClosed(EJBClientContext ejbClientContext) {
            ConfigBasedEJBClientContextSelector.this.remotingConnectionManager.safeClose();
            ConfigBasedEJBClientContextSelector.this.remotingEndpointManager.safeClose();
        }

        @Override
        public void receiverRegistered(EJBReceiverContext receiverContext) {
        }

        @Override
        public void receiverUnRegistered(EJBReceiverContext receiverContext) {
        }
    }
}

