/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.UnknownURISchemeException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.sasl.util.SaslFactories;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;

@Deprecated
public class NetworkUtil {
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    private static int getInt(byte[] b, int offs) {
        return (b[offs] & 0xFF) << 24 | (b[offs + 1] & 0xFF) << 16 | (b[offs + 2] & 0xFF) << 8 | b[offs + 3] & 0xFF;
    }

    private static long getLong(byte[] b, int offs) {
        return ((long)NetworkUtil.getInt(b, offs) & 0xFFFFFFFFL) << 32 | (long)NetworkUtil.getInt(b, offs + 4) & 0xFFFFFFFFL;
    }

    private static int nwsl(int arg, int places) {
        return places <= 0 ? arg : (places >= 32 ? 0 : arg << places);
    }

    private static long nwsl(long arg, int places) {
        return places <= 0 ? arg : (places >= 64 ? 0L : arg << places);
    }

    public static boolean belongsToNetwork(InetAddress address, InetAddress networkAddress, int networkMask) {
        if (address == null || networkAddress == null) {
            return false;
        }
        if (networkMask == 0) {
            return true;
        }
        byte[] addressBytes = address.getAddress();
        byte[] networkAddressBytes = networkAddress.getAddress();
        if (address instanceof Inet4Address && networkAddress instanceof Inet4Address) {
            int netAddr;
            int maskBits = NetworkUtil.nwsl(-1, 32 - networkMask);
            int addr = NetworkUtil.getInt(addressBytes, 0) & maskBits;
            return addr == (netAddr = NetworkUtil.getInt(networkAddressBytes, 0) & maskBits);
        }
        if (address instanceof Inet6Address && networkAddress instanceof Inet6Address) {
            long maskHigh = NetworkUtil.nwsl(-1L, 64 - networkMask);
            long maskLow = NetworkUtil.nwsl(-1L, 128 - networkMask);
            long addrHigh = NetworkUtil.getLong(addressBytes, 0) & maskHigh;
            long addrLow = NetworkUtil.getLong(addressBytes, 8) & maskLow;
            long netAddrHigh = NetworkUtil.getLong(networkAddressBytes, 0) & maskHigh;
            long netAddrLow = NetworkUtil.getLong(networkAddressBytes, 8) & maskLow;
            return addrHigh == netAddrHigh && addrLow == netAddrLow;
        }
        return false;
    }

    static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    public static IoFuture<Connection> connect(Endpoint endpoint, String protocol, String destinationHost, int destinationPort, InetSocketAddress sourceBindAddress, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
        InetSocketAddress destinationSocketAddress = new InetSocketAddress(NetworkUtil.formatPossibleIpv6Address(destinationHost), destinationPort);
        return NetworkUtil.connect(endpoint, protocol, destinationSocketAddress, sourceBindAddress, connectionCreationOptions, callbackHandler, sslContext);
    }

    public static IoFuture<Connection> connect(Endpoint endpoint, String protocol, InetSocketAddress destination, InetSocketAddress sourceBindAddress, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
        Map<String, String> saslProperties;
        URI uri;
        if (!endpoint.isValidUriScheme(protocol)) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + protocol + "\" is installed");
        }
        try {
            uri = new URI(protocol, null, destination.getHostString(), destination.getPort(), "", "", "");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        AuthenticationContext captured = AuthenticationContext.captureCurrent();
        AuthenticationConfiguration mergedConfiguration = AUTH_CONFIGURATION_CLIENT.getAuthenticationConfiguration(uri, captured);
        if (callbackHandler != null) {
            mergedConfiguration = mergedConfiguration.useCallbackHandler(callbackHandler);
        }
        if (sslContext != null) {
            mergedConfiguration = mergedConfiguration.useSslContext(sslContext);
        }
        if ((saslProperties = NetworkUtil.getSaslProperties(connectionCreationOptions)) != null) {
            mergedConfiguration = mergedConfiguration.useMechanismProperties(saslProperties);
        }
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, mergedConfiguration);
        return endpoint.connect(uri, sourceBindAddress, connectionCreationOptions, context, SaslFactories.getElytronSaslClientFactory());
    }

    private static Map<String, String> getSaslProperties(OptionMap connectionCreationOptions) {
        HashMap<String, String> saslProperties = null;
        Sequence value = (Sequence)connectionCreationOptions.get(Options.SASL_PROPERTIES);
        if (value != null) {
            saslProperties = new HashMap<String, String>(value.size());
            for (Property property : value) {
                saslProperties.put(property.getKey(), (String)property.getValue());
            }
        }
        return saslProperties;
    }
}

