/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import javax.transaction.Transaction;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.annotation.ClientTransactionPolicy;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;

public final class TransactionInterceptor
implements EJBClientInterceptor {
    private static final ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        ClientTransactionPolicy transactionPolicy = context.getTransactionPolicy();
        URI uri = context.getLocator().getAffinity().getUri();
        AbstractTransaction transaction = transactionManager.getTransaction();
        if (transactionPolicy.failIfTransactionAbsent() && transaction == null) {
            throw Logs.TXN.txNotActiveForThread();
        }
        if (transactionPolicy.failIfTransactionPresent() && transaction != null) {
            throw Logs.TXN.txAlreadyAssociatedWithThread();
        }
        if (transactionPolicy.propagate()) {
            context.setTransaction((Transaction)transaction);
        }
        if (transaction != null) {
            transactionManager.suspend();
            try {
                context.sendRequest();
            }
            finally {
                transactionManager.resume((Transaction)transaction);
            }
        }
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        return context.getResult();
    }
}

