/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.versioned.CollectionStateManager;
import org.jboss.aspects.versioned.DistributedMapUpdate;
import org.jboss.aspects.versioned.DistributedState;
import org.jboss.aspects.versioned.DistributedUpdate;
import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.OptimisticLockFailure;
import org.jboss.aspects.versioned.SynchronizationManager;
import org.jboss.aspects.versioned.VersionManager;
import org.jboss.aspects.versioned.VersionReference;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.util.id.GUID;

public class DistributedMapState
extends CollectionStateManager
implements Map,
DistributedState,
Externalizable {
    private static final long serialVersionUID = -5397547850033533784L;
    private static HashMap mapMethodMap;
    protected static Logger log;
    protected volatile long versionId;
    protected HashMap updates;
    protected String classname;
    protected transient Map base;
    protected transient TransactionLocal txState = new TransactionLocal();
    protected transient TransactionLocal txVersion = new TransactionLocal();
    protected transient DistributedVersionManager versionManager;
    protected transient SynchronizationManager synchManager;
    protected transient TransactionManager tm;
    protected transient ClassProxy proxy;

    public DistributedMapState() {
    }

    public DistributedMapState(GUID guid, long timeout, ClassProxy proxy, Map obj, DistributedVersionManager versionManager, SynchronizationManager synchManager) throws Exception {
        super(guid, timeout, mapMethodMap);
        this.base = obj;
        this.classname = obj.getClass().getName();
        this.versionManager = versionManager;
        this.synchManager = synchManager;
        this.proxy = proxy;
        InitialContext ctx = new InitialContext();
        this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        this.updates = this.createMapUpdates(this.base);
    }

    public HashMap getMethodMap() {
        return ClassProxyFactory.getMethodMap((String)this.base.getClass().getName());
    }

    public InstanceAdvised getObject() {
        return this.proxy;
    }

    protected Map getCurrentState(boolean forUpdate) throws Exception {
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            if (forUpdate) {
                ++this.versionId;
            }
            return this.base;
        }
        Map state = (Map)this.txState.get(tx);
        if (state == null && forUpdate) {
            state = (Map)this.base.getClass().newInstance();
            state.putAll(this.base);
            this.txState.set(tx, (Object)state);
            long newId = this.versionId + 1L;
            this.synchManager.registerUpdate(tx, this);
            this.txVersion.set(tx, (Object)new Long(newId));
            return state;
        }
        return this.base;
    }

    protected HashMap createMapUpdates(Map state) {
        HashMap mapUpdates = new HashMap();
        for (Map.Entry entry : state.entrySet()) {
            Object obj = entry.getValue();
            if (this.versionManager.isVersioned(obj)) {
                mapUpdates.put(entry.getKey(), new VersionReference(VersionManager.getGUID((InstanceAdvised)obj)));
                continue;
            }
            mapUpdates.put(entry.getKey(), (VersionReference)obj);
        }
        return mapUpdates;
    }

    public DistributedUpdate createTxUpdate(Transaction tx) {
        Map state = (Map)this.txState.get(tx);
        long newId = (Long)this.txVersion.get(tx);
        DistributedMapUpdate update = new DistributedMapUpdate(this.guid, this.createMapUpdates(state), newId);
        return update;
    }

    public InstanceAdvised buildObject(SynchronizationManager manager, DistributedVersionManager versionManager) throws Exception {
        log.trace((Object)"building a Map");
        this.versionManager = versionManager;
        this.synchManager = manager;
        log.trace((Object)("DistributedMaptState: classname: " + this.classname));
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
        this.base = (Map)clazz.newInstance();
        for (Map.Entry entry : this.updates.entrySet()) {
            VersionReference ref;
            Object val = entry.getValue();
            if (val instanceof VersionReference && (val = manager.getObject((ref = (VersionReference)val).getGUID())) == null) {
                DistributedState fieldVal = manager.getState(ref.getGUID());
                val = fieldVal.buildObject(manager, versionManager);
                ref.set((InstanceAdvised)val);
            }
            this.base.put(entry.getKey(), val);
        }
        this.proxy = versionManager.addMapVersioning(this.base, this);
        return this.proxy;
    }

    public void checkOptimisticLock(Transaction tx) {
        Long version = (Long)this.txVersion.get(tx);
        if (version <= this.versionId) {
            throw new OptimisticLockFailure("optimistic lock failure for list");
        }
    }

    public void mergeState(Transaction tx) throws Exception {
        Map current;
        this.base = current = (Map)this.txState.get(tx);
        Long version = (Long)this.txVersion.get(tx);
        this.versionId = version;
    }

    public void mergeState(DistributedUpdate update) throws Exception {
        DistributedMapUpdate mapUpdate = (DistributedMapUpdate)update;
        this.versionId = mapUpdate.versionId;
        this.base.clear();
        for (Map.Entry entry : mapUpdate.mapUpdates.entrySet()) {
            Object val = entry.getValue();
            if (val instanceof VersionReference) {
                VersionReference ref = (VersionReference)val;
                val = this.synchManager.getObject(ref.getGUID());
                ref.set((InstanceAdvised)val);
            }
            this.base.put(entry.getKey(), val);
        }
        this.updates = mapUpdate.mapUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.lock.readLock().acquire();
            try {
                Map state = this.getCurrentState(true);
                state.clear();
            }
            finally {
                this.lock.readLock().release();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object o) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            bl = state.containsKey(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object o) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            bl = state.containsKey(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        Set set;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            set = state.entrySet();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            bl = ((Object)state).equals(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object o) {
        Object v;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            v = state.get(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            n = ((Object)state).hashCode();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            bl = state.isEmpty();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Set set;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            set = state.keySet();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object val) {
        Object object;
        this.lock.readLock().acquire();
        try {
            val = this.versionManager.makeVersioned(val);
            Map state = this.getCurrentState(true);
            object = state.put(key, val);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map c) {
        try {
            this.lock.readLock().acquire();
            try {
                Map state = this.getCurrentState(true);
                for (Map.Entry entry : state.entrySet()) {
                    Object val = this.versionManager.makeVersioned(entry.getValue());
                    state.put(entry.getKey(), val);
                }
            }
            finally {
                this.lock.readLock().release();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object v;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(true);
            v = state.remove(key);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            n = state.size();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        Collection collection;
        this.lock.readLock().acquire();
        try {
            Map state = this.getCurrentState(false);
            collection = state.values();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return collection;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.versionId);
        out.writeObject(this.updates);
        out.writeObject(this.classname);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.versionId = in.readLong();
        this.updates = (HashMap)in.readObject();
        this.classname = (String)in.readObject();
        try {
            InitialContext ctx = new InitialContext();
            this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.txState = new TransactionLocal();
        this.txVersion = new TransactionLocal();
        this.methodMap = mapMethodMap;
    }

    static {
        log = Logger.getLogger(DistributedMapState.class);
        try {
            mapMethodMap = new HashMap();
            Method[] methods = Map.class.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                long hash = MethodHashing.methodHash((Method)methods[i]);
                mapMethodMap.put(new Long(hash), methods[i]);
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }
}

