/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.ejb.EJB;
import org.jboss.ejb3.client.Utils;
import org.jboss.injection.AbstractHandler;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.Injector;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.AbstractEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientEJBHandler<X extends RemoteEnvironment>
extends AbstractHandler<X> {
    private static final Logger log = Logger.getLogger(ClientEJBHandler.class);

    public void loadXml(X xml, InjectionContainer container) {
        if (xml != null) {
            log.trace((Object)("ejbRefs = " + xml.getEjbReferences()));
            try {
                if (xml.getAnnotatedEjbReferences() != null) {
                    this.loadEjbRefXml(xml.getAnnotatedEjbReferences(), container);
                }
                if (xml.getEjbReferences() != null) {
                    this.loadEjbRefXml((Collection<EJBReferenceMetaData>)xml.getEjbReferences(), container);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        throw new IllegalStateException("Annotations are not handled");
    }

    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        throw new IllegalStateException("Annotations are not handled");
    }

    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        throw new IllegalStateException("Annotations are not handled");
    }

    protected void loadEjbRefXml(AnnotatedEJBReferencesMetaData refs, InjectionContainer container) throws Exception {
        for (AnnotatedEJBReferenceMetaData ref : refs) {
            String interfaceName = ref.getBeanInterface().getName();
            String errorType = "@EJB";
            this.ejbRefXml((AbstractEJBReferenceMetaData)ref, interfaceName, container, errorType);
        }
    }

    protected void loadEjbRefXml(Collection<EJBReferenceMetaData> refs, InjectionContainer container) throws Exception {
        for (EJBReferenceMetaData ref : refs) {
            String interfaceName = ref.getRemote();
            String errorType = "<ejb-ref>";
            this.ejbRefXml((AbstractEJBReferenceMetaData)ref, interfaceName, container, errorType);
        }
    }

    protected void ejbRefXml(AbstractEJBReferenceMetaData ref, String interfaceName, InjectionContainer container, String errorType) throws Exception {
        String encName = "env/" + ref.getEjbRefName();
        Utils.injectionTarget(encName, (ResourceInjectionMetaData)ref, container);
    }

    protected String getEncName(EJB ref, Field field) {
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? Utils.getEncName(field) : "env/" + encName;
        return encName;
    }

    protected String getEncName(EJB ref, Method method) {
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? Utils.getEncName(method) : "env/" + encName;
        return encName;
    }
}

