/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.clientmodule;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.ejb.EJB;
import javax.naming.NameNotFoundException;
import org.jboss.ejb3.EJBContainer;
import org.jboss.injection.EJBInjectionHandler;
import org.jboss.injection.EjbEncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.AbstractEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBRemoteHandler<X extends RemoteEnvironment>
extends EJBInjectionHandler<X> {
    private static final Logger log = Logger.getLogger(EJBRemoteHandler.class);

    public void loadXml(X xml, InjectionContainer container) {
        if (xml != null) {
            log.trace((Object)("ejbRefs = " + xml.getEjbReferences()));
            if (xml.getAnnotatedEjbReferences() != null) {
                this.loadEjbRefXml(xml.getAnnotatedEjbReferences(), container);
            }
            if (xml.getEjbReferences() != null) {
                this.loadEjbRefXml((Collection<EJBReferenceMetaData>)xml.getEjbReferences(), container);
            }
        }
    }

    protected void loadEjbRefXml(AnnotatedEJBReferencesMetaData refs, InjectionContainer container) {
        for (AnnotatedEJBReferenceMetaData ref : refs) {
            String interfaceName = ref.getBeanInterface().getName();
            String errorType = "@EJB";
            this.ejbRefXml((AbstractEJBReferenceMetaData)ref, interfaceName, container, errorType);
        }
    }

    protected void loadEjbRefXml(Collection<EJBReferenceMetaData> refs, InjectionContainer container) {
        for (EJBReferenceMetaData ref : refs) {
            String interfaceName = ref.getRemote();
            String errorType = "<ejb-ref>";
            this.ejbRefXml((AbstractEJBReferenceMetaData)ref, interfaceName, container, errorType);
        }
    }

    protected void ejbRefXml(AbstractEJBReferenceMetaData ref, String interfaceName, InjectionContainer container, String errorType) {
        String link;
        String encName = "env/" + ref.getEjbRefName();
        InjectionUtil.injectionTarget((String)encName, (ResourceInjectionMetaData)ref, (InjectionContainer)container, (Map)container.getEncInjections());
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        String mappedName = ref.getMappedName();
        if (mappedName != null && mappedName.equals("")) {
            mappedName = null;
        }
        if (mappedName == null && ref.getResolvedJndiName() != null) {
            mappedName = ref.getResolvedJndiName();
        }
        if ((link = ref.getLink()) != null && link.trim().equals("")) {
            link = null;
        }
        Class<?> refClass = null;
        if (interfaceName != null) {
            try {
                refClass = container.getClassloader().loadClass(interfaceName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("could not find " + errorType + "'s local interface " + interfaceName + " in " + container.getDeploymentDescriptorType() + " of " + container.getIdentifier());
            }
        }
        if (mappedName != null || refClass != null || link != null) {
            this.ejbRefEncInjector(mappedName, encName, null, refClass, link, errorType, container);
            if (ref.getIgnoreDependency() != null) {
                log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + encName));
                return;
            }
            this.ejbRefDependency(mappedName, link, container, refClass, errorType, encName);
        }
    }

    protected void ejbRefDependency(String mappedName, String link, InjectionContainer container, Class<?> refClass, String errorType, String encName) {
        if (mappedName != null && mappedName.length() == 0) {
            mappedName = null;
        }
        if (refClass != null && (refClass.equals(Object.class) || refClass.equals(Void.TYPE))) {
            refClass = null;
        }
        if (mappedName != null) {
            this.addJNDIDependency(container, mappedName);
            return;
        }
        if (refClass != null) {
            if (link != null && !link.trim().equals("")) {
                this.addDependency(container, link, refClass);
            } else {
                this.addDependency(container, refClass);
            }
        } else {
            String msg = "IGNORING DEPENDENCY: unable to resolve dependency of EJB, there is too little information";
            log.warn((Object)msg);
        }
    }

    protected void ejbRefEncInjector(String mappedName, String encName, String fieldName, Class refClass, String link, String errorType, InjectionContainer container) {
        AnnotatedEJBReferencesMetaData amds;
        if (refClass != null && (refClass.equals(Object.class) || refClass.equals(Void.TYPE))) {
            refClass = null;
        }
        if (mappedName != null && mappedName.trim().equals("")) {
            mappedName = null;
        }
        if (mappedName == null && (amds = container.getEnvironmentRefGroup().getAnnotatedEjbReferences()) != null) {
            AnnotatedEJBReferenceMetaData amd = (AnnotatedEJBReferenceMetaData)amds.get(encName);
            if (amd == null && fieldName != null) {
                amd = (AnnotatedEJBReferenceMetaData)amds.get(fieldName);
            }
            if (amd != null && (mappedName = amd.getMappedName()) == null) {
                mappedName = amd.getResolvedJndiName();
            }
        }
        EjbEncInjector injector = null;
        injector = mappedName == null ? new EjbEncInjector(encName, refClass, link, errorType) : new EjbEncInjector(encName, mappedName, errorType);
        container.getEncInjectors().put(encName, injector);
    }

    public static EJBContainer getEjbContainer(EJB ref, InjectionContainer container, Class<?> memberType) {
        EJBContainer rtn = null;
        if (ref.mappedName() != null && !"".equals(ref.mappedName())) {
            return null;
        }
        if (ref.beanName().equals("") && memberType == null) {
            throw new RuntimeException("For deployment " + container.getIdentifier() + "not enough information for @EJB.  Please fill out the beanName and/or businessInterface attributes");
        }
        Class businessInterface = memberType;
        if (!ref.beanInterface().getName().equals(Object.class.getName())) {
            businessInterface = ref.beanInterface();
        }
        if (ref.beanName().equals("")) {
            try {
                rtn = (EJBContainer)container.resolveEjbContainer(businessInterface);
            }
            catch (NameNotFoundException e) {
                log.warn((Object)("For deployment " + container.getIdentifier() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ") " + e.getMessage()));
            }
        } else {
            rtn = (EJBContainer)container.resolveEjbContainer(ref.beanName(), businessInterface);
        }
        return rtn;
    }

    public static String getJndiName(EJB ref, InjectionContainer container, Class<?> memberType) {
        String jndiName;
        if (ref.mappedName() != null && !"".equals(ref.mappedName())) {
            return ref.mappedName();
        }
        if (ref.beanName().equals("") && memberType == null) {
            throw new RuntimeException("For deployment " + container.getIdentifier() + "not enough information for @EJB.  Please fill out the beanName and/or businessInterface attributes");
        }
        Class businessInterface = memberType;
        if (!ref.beanInterface().getName().equals(Object.class.getName())) {
            businessInterface = ref.beanInterface();
        }
        if (ref.beanName().equals("")) {
            try {
                jndiName = container.getEjbJndiName(businessInterface);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("For deployment " + container.getIdentifier() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ") " + e.getMessage());
            }
            if (jndiName == null) {
                throw new RuntimeException("For deployment " + container.getIdentifier() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ")");
            }
        } else {
            jndiName = container.getEjbJndiName(ref.beanName(), businessInterface);
            if (jndiName == null) {
                throw new RuntimeException("For EJB " + container.getIdentifier() + "could not find jndi binding based on beanName and business interface for @EJB(" + ref.beanName() + ", " + businessInterface.getName() + ")");
            }
        }
        return jndiName;
    }

    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        throw new IllegalStateException("handleClassAnnotation cannot be used in a client");
    }

    protected void handleClassAnnotation(EJB ejb, Class<?> clazz, InjectionContainer container) {
        throw new IllegalStateException("handleClassAnnotation cannot be used in a client");
    }

    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        throw new IllegalStateException("handleMethodAnnotations cannot be used in a client");
    }

    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        throw new IllegalStateException("handleFieldAnnotations cannot be used in a client");
    }

    protected boolean isIgnoreDependency(InjectionContainer container, EJB ref) {
        RemoteEnvironment refGroup = container.getEnvironmentRefGroup();
        if (refGroup != null && refGroup.getEjbReferences() != null) {
            for (EJBReferenceMetaData ejbRef : refGroup.getEjbReferences()) {
                if (!ejbRef.getEjbRefName().equals(ref.name())) continue;
                return ejbRef.getIgnoreDependency() != null;
            }
        }
        return false;
    }
}

