/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.mx.util.JMXInvocationHandler;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.ProxyContext;

public class MBeanProxy {
    public static Object get(Class intrface, ObjectName name, String agentID) throws MBeanProxyCreationException {
        return MBeanProxy.get(intrface, name, MBeanServerFactory.findMBeanServer(agentID).get(0));
    }

    public static Object get(Class intrface, ObjectName name, MBeanServer server) throws MBeanProxyCreationException {
        return MBeanProxy.get(new Class[]{intrface, ProxyContext.class, DynamicMBean.class}, name, server);
    }

    public static Object get(ObjectName name, MBeanServer server) throws MBeanProxyCreationException {
        return MBeanProxy.get(new Class[]{ProxyContext.class, DynamicMBean.class}, name, server);
    }

    private static Object get(Class[] interfaces, ObjectName name, MBeanServer server) throws MBeanProxyCreationException {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)new JMXInvocationHandler(server, name));
    }

    public static Object create(Class instance, Class intrface, ObjectName name, String agentID) throws MBeanProxyCreationException {
        return MBeanProxy.create(instance, intrface, name, MBeanServerFactory.findMBeanServer(agentID).get(0));
    }

    public static Object create(Class instance, Class intrface, ObjectName name, MBeanServer server) throws MBeanProxyCreationException {
        try {
            server.createMBean(instance.getName(), name);
            return MBeanProxy.get(intrface, name, server);
        }
        catch (ReflectionException e) {
            throw new MBeanProxyCreationException("Creating the MBean failed: " + e.toString());
        }
        catch (InstanceAlreadyExistsException e) {
            throw new MBeanProxyCreationException("Instance already exists: " + name);
        }
        catch (MBeanRegistrationException e) {
            throw new MBeanProxyCreationException("Error registering the MBean to the server: " + e.toString());
        }
        catch (MBeanException e) {
            throw new MBeanProxyCreationException(e.toString());
        }
        catch (NotCompliantMBeanException e) {
            throw new MBeanProxyCreationException("Not a compliant MBean " + instance.getClass().getName() + ": " + e.toString());
        }
    }
}

