/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import junit.framework.TestCase;

public class OpenMBeanAttributeInfoSupportTestCase
extends TestCase {
    public OpenMBeanAttributeInfoSupportTestCase(String s) {
        super(s);
    }

    public void testOpenMBeanAttributeInfoSupport() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false, "default");
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)"default", (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasDefaultValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false, (String)null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasDefaultValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(3), (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(2), info.getMinValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(4), info.getMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer(2), new Integer(4));
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(2), info.getMinValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(4), info.getMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), null, new Integer(4));
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(3), (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getMinValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(4), info.getMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(3), (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(2), info.getMinValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null, new Integer(4));
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getMinValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(4), info.getMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer(2), null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(2), info.getMinValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), null, null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)new Integer(3), (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getMinValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null, null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getMinValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false, "default", new String[]{"legal1", "legal2", "default"});
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)"default", (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((int)3, (int)info.getLegalValues().size());
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"legal1 should be a legal value", (boolean)info.getLegalValues().contains("legal1"));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"legal2 should be a legal value", (boolean)info.getLegalValues().contains("legal2"));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"default should be a legal value", (boolean)info.getLegalValues().contains("default"));
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false, null, new String[]{"legal1", "legal2", "default"});
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((int)3, (int)info.getLegalValues().size());
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"legal1 should be a legal value", (boolean)info.getLegalValues().contains("legal1"));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"legal2 should be a legal value", (boolean)info.getLegalValues().contains("legal2"));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"default should be a legal value", (boolean)info.getLegalValues().contains("default"));
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false, "default", null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)"default", (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getLegalValues());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false, null, null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(null, info.getLegalValues());
    }

    public void testOpenType() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals(SimpleType.STRING, info.getOpenType());
    }

    public void testHas() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false, "default");
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasDefaultValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false, (String)null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasDefaultValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer(3), null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasMinValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null, null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasMinValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null, new Integer(3));
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null, null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasMaxValue());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer[]{new Integer(3)});
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasLegalValues());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasLegalValues());
    }

    public void testIsValue() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"String should be a value", (boolean)info.isValue("string"));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Integer should not be a value", (!info.isValue(new Integer(3)) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Null should not be a value", (!info.isValue(null) ? 1 : 0) != 0);
    }

    public void testIsWritable() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isWritable());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, false, false);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isWritable());
    }

    public void testIsReadable() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isReadable());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, false, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isReadable());
    }

    public void testIsIs() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.BOOLEAN, true, true, true);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.isIs());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.isIs());
    }

    public void testEquals() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Null should not be equal", (!info.equals(null) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Only OpenMBeanAttributeInfo should be equal", (!info.equals(new Object()) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupport info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same data are equal", (boolean)info.equals(info2));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same data are equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description2", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances with different descriptions are equal", (boolean)info.equals(info2));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances with different descritpions are equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanAttributeInfoSupport("name2", "description", SimpleType.STRING, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different types are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different types are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, false, true, false);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different read are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different read are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, false, false);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different write are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different write are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.BOOLEAN, true, true, true);
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.BOOLEAN, true, true, true);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different write are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different write are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(2), new Integer(2), new Integer(4));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different default values are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different default values are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(2), null, new Integer(4));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different default values are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different default values are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same default value are equal", (boolean)info.equals(info2));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same default value are equal", (boolean)info2.equals(info));
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer(2), null);
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer(2), null);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same minimum are equal", (boolean)info.equals(info2));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same minimum are equal", (boolean)info2.equals(info));
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null, new Integer(2));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null, new Integer(2));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same maximum are equal", (boolean)info.equals(info2));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same maximum are equal", (boolean)info2.equals(info));
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(1), new Integer(4));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different minimums are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different minimums are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), null, new Integer(4));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different minimums are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different minimums are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(5));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different maximums are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different maximums are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), null);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different maximums are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Instances with different maximums are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer[]{new Integer(2), new Integer(3)});
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer[]{new Integer(2), new Integer(3)});
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same legal values are equal", (boolean)info.equals(info2));
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances of the same legal values are equal", (boolean)info2.equals(info));
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer[]{new Integer(2), new Integer(3)});
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer[]{new Integer(2), new Integer(4)});
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer[]{new Integer(2), new Integer(3)});
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer[]{new Integer(2)});
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer[]{new Integer(2), new Integer(3)});
        info2 = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, null);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        int myHash = "name".hashCode() + SimpleType.INTEGER.hashCode() + new Integer(3).hashCode() + new Integer(2).hashCode() + new Integer(4).hashCode();
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((int)myHash, (int)info.hashCode());
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer[]{new Integer(2), new Integer(3), new Integer(4)});
        myHash = "name".hashCode() + SimpleType.INTEGER.hashCode() + new Integer(3).hashCode() + new Integer(2).hashCode() + new Integer(3).hashCode() + new Integer(4).hashCode();
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((int)myHash, (int)info.hashCode());
    }

    public void testToString() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        String toString = info.toString();
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"info.toString() should contain the name", (toString.indexOf("name") != -1 ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"info.toString() should contain the simple type", (toString.indexOf(SimpleType.INTEGER.toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"info.toString() should contain the default value", (toString.indexOf(new Integer(3).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"info.toString() should contain the minimum value", (toString.indexOf(new Integer(2).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"info.toString() should contain the maximum value", (toString.indexOf(new Integer(4).toString()) != -1 ? 1 : 0) != 0);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer[]{new Integer(2), new Integer(3), new Integer(4)});
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"info.toString() should contain the legal value 2", (toString.indexOf(new Integer(2).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"info.toString() should contain the legal value 3", (toString.indexOf(new Integer(3).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanAttributeInfoSupportTestCase.assertTrue((String)"info.toString() should contain the legal value 4", (toString.indexOf(new Integer(4).toString()) != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        OpenMBeanAttributeInfoSupport info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(2), new Integer(4));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)info, (Object)result);
        info = new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer[]{new Integer(2), new Integer(3), new Integer(4)});
        baos = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        bais = new ByteArrayInputStream(baos.toByteArray());
        ois = new ObjectInputStream(bais);
        result = ois.readObject();
        OpenMBeanAttributeInfoSupportTestCase.assertEquals((Object)info, (Object)result);
    }

    public void testErrors1() throws Exception {
        boolean caught = false;
        try {
            new OpenMBeanAttributeInfoSupport(null, "description", SimpleType.INTEGER, true, true, false);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("", "description", SimpleType.INTEGER, true, true, false);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", null, SimpleType.INTEGER, true, true, false);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "", SimpleType.INTEGER, true, true, false);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty description");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("", "description", SimpleType.INTEGER, true, true, false);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", null, true, true, false);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null simple type");
        }
    }

    public void testErrors2() throws Exception {
        TabularType tabularType;
        String[] indexNames;
        CompositeType rowType;
        OpenType[] itemTypes;
        String[] itemDescriptions;
        String[] itemNames;
        ArrayType arrayType;
        boolean caught = false;
        try {
            new OpenMBeanAttributeInfoSupport(null, "description", SimpleType.INTEGER, true, true, false, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("", "description", SimpleType.INTEGER, true, true, false, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", null, SimpleType.INTEGER, true, true, false, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "", SimpleType.INTEGER, true, true, false, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty description");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("", "description", SimpleType.INTEGER, true, true, false, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", null, true, true, false, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null simple type");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, new String[0]);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, (String[])null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't execpt OpenDataException for array type and no default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            TabularDataSupport data = new TabularDataSupport(tabularType);
            new OpenMBeanAttributeInfoSupport("name", "description", tabularType, true, true, false, data);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for tabular type and default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            new OpenMBeanAttributeInfoSupport("name", "description", tabularType, true, true, false, (TabularData)null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't execpt OpenDataException for tabular type and null default value");
        }
    }

    public void testErrors3() throws Exception {
        TabularDataSupport data;
        TabularType tabularType;
        String[] indexNames;
        CompositeType rowType;
        OpenType[] itemTypes;
        String[] itemDescriptions;
        String[] itemNames;
        ArrayType arrayType;
        boolean caught = false;
        try {
            new OpenMBeanAttributeInfoSupport(null, "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", null, SimpleType.INTEGER, true, true, false, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty description");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", null, true, true, false, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null simple type");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, new String[0], null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for array type and no default value and legals");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            data = new TabularDataSupport(tabularType);
            new OpenMBeanAttributeInfoSupport("name", "description", tabularType, true, true, false, data, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for tabular type and default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            new OpenMBeanAttributeInfoSupport("name", "description", tabularType, true, true, false, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for tabular type and null default value and legals");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, null, new String[]{"hello", "goodbye"});
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, null, new String[0]);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for array type and no default value and empty legals");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            data = new TabularDataSupport(tabularType);
            new OpenMBeanAttributeInfoSupport("name", "description", tabularType, true, true, false, null, new TabularDataSupport[]{data});
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for tabular type and legal values");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            new OpenMBeanAttributeInfoSupport("name", "description", tabularType, true, true, false, null, new TabularDataSupport[0]);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for tabular type and null default value and empty legals");
        }
    }

    public void testErrors4() throws Exception {
        TabularType tabularType;
        String[] indexNames;
        CompositeType rowType;
        OpenType[] itemTypes;
        String[] itemDescriptions;
        String[] itemNames;
        ArrayType arrayType;
        boolean caught = false;
        try {
            new OpenMBeanAttributeInfoSupport(null, "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", null, SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty description");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("", "description", SimpleType.INTEGER, true, true, false, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", null, true, true, false, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null simple type");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, new String[0], null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, null, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for array type and no default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            TabularDataSupport data = new TabularDataSupport(tabularType);
            new OpenMBeanAttributeInfoSupport("name", "description", tabularType, true, true, false, data, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for tabular type and default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            new OpenMBeanAttributeInfoSupport("name", "description", tabularType, true, true, false, null, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for tabular type and null default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            new OpenMBeanAttributeInfoSupport("name", "description", arrayType, true, true, false, new String[]{"hello", "goodbye"}, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(4), new Integer(4), new Integer(5));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for default value equal minimum value");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(6), new Integer(4), new Integer(5));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for default value greater than maximum value");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, new Integer(5), new Integer(4), new Integer(5));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for default value equal maximum value");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer(4), new Integer(3));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Expected OpenDataException for minimum greater than maximum value");
        }
        caught = false;
        try {
            new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.INTEGER, true, true, false, null, new Integer(4), new Integer(4));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanAttributeInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for minimum equal maximum value");
        }
    }
}

