/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.relation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;
import junit.framework.TestCase;

public class RoleUnresolvedListTestCase
extends TestCase {
    boolean setUpDone = false;
    RoleUnresolved roleUnresolved1;
    RoleUnresolved roleUnresolved2;

    public RoleUnresolvedListTestCase(String s) {
        super(s);
    }

    public void testEmptyConstructors() {
        this.setUpRoleUnresolveds();
        RoleUnresolvedList empty = new RoleUnresolvedList();
        RoleUnresolvedListTestCase.assertEquals((int)0, (int)empty.size());
        empty = new RoleUnresolvedList(100);
        RoleUnresolvedListTestCase.assertEquals((int)0, (int)empty.size());
    }

    public void testBasicConstructor() {
        this.setUpRoleUnresolveds();
        ArrayList<RoleUnresolved> roleUnresolveds = new ArrayList<RoleUnresolved>();
        roleUnresolveds.add(this.roleUnresolved1);
        roleUnresolveds.add(this.roleUnresolved2);
        RoleUnresolvedList full = new RoleUnresolvedList((List<RoleUnresolved>)roleUnresolveds);
        RoleUnresolvedListTestCase.assertEquals((int)2, (int)full.size());
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved1, full.get(0));
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved2, full.get(1));
        Iterator iterator = full.iterator();
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved1, iterator.next());
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved2, iterator.next());
    }

    public void testBasicConstructorOrdering() {
        this.setUpRoleUnresolveds();
        ArrayList<RoleUnresolved> roleUnresolveds = new ArrayList<RoleUnresolved>();
        roleUnresolveds.add(this.roleUnresolved2);
        roleUnresolveds.add(this.roleUnresolved1);
        RoleUnresolvedList full = new RoleUnresolvedList((List<RoleUnresolved>)roleUnresolveds);
        RoleUnresolvedListTestCase.assertEquals((int)2, (int)full.size());
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved2, full.get(0));
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved1, full.get(1));
        Iterator iterator = full.iterator();
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved2, iterator.next());
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved1, iterator.next());
    }

    public void testBasicConstructorDuplicates() {
        this.setUpRoleUnresolveds();
        ArrayList<RoleUnresolved> roleUnresolveds = new ArrayList<RoleUnresolved>();
        roleUnresolveds.add(this.roleUnresolved1);
        roleUnresolveds.add(this.roleUnresolved1);
        RoleUnresolvedList full = new RoleUnresolvedList((List<RoleUnresolved>)roleUnresolveds);
        RoleUnresolvedListTestCase.assertEquals((int)2, (int)full.size());
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved1, full.get(0));
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved1, full.get(1));
        Iterator iterator = full.iterator();
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved1, iterator.next());
        RoleUnresolvedListTestCase.assertEquals((Object)this.roleUnresolved1, iterator.next());
    }

    public void testErrorHandling() {
        this.setUpRoleUnresolveds();
        ArrayList<RoleUnresolved> roleUnresolveds = new ArrayList<RoleUnresolved>();
        roleUnresolveds.add(this.roleUnresolved1);
        roleUnresolveds.add(null);
        boolean caught = false;
        try {
            new RoleUnresolvedList((List<RoleUnresolved>)roleUnresolveds);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"Constructor accepts null roleUnresolveds");
        }
        roleUnresolveds = new ArrayList();
        roleUnresolveds.add(this.roleUnresolved1);
        roleUnresolveds.add((RoleUnresolved)new Object());
        caught = false;
        try {
            new RoleUnresolvedList((List<RoleUnresolved>)roleUnresolveds);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"Constructor accepts non roleUnresolveds");
        }
    }

    public void testSingleAppend() {
        this.setUpRoleUnresolveds();
        RoleUnresolvedList list = new RoleUnresolvedList();
        list.add(this.roleUnresolved1);
        RoleUnresolvedListTestCase.assertEquals((int)1, (int)list.size());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(0).toString());
        Iterator iterator = list.iterator();
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        list.add(this.roleUnresolved2);
        RoleUnresolvedListTestCase.assertEquals((int)2, (int)list.size());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(0).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)list.get(1).toString());
        iterator = list.iterator();
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.add(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"RoleUnresolved add(null) shouldn't work");
        }
    }

    public void testSingleAdd() {
        this.setUpRoleUnresolveds();
        RoleUnresolvedList list = new RoleUnresolvedList();
        list.add(this.roleUnresolved1);
        list.add(this.roleUnresolved2);
        list.add(1, this.roleUnresolved1);
        RoleUnresolvedListTestCase.assertEquals((int)3, (int)list.size());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(0).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(1).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)list.get(2).toString());
        Iterator iterator = list.iterator();
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.add(4, this.roleUnresolved1);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"Shouldn't be able to add a roleUnresolved outside of valid range");
        }
        caught = false;
        try {
            list.add(1, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"Shouldn't be able to add a null at an index");
        }
    }

    public void testSingleSet() {
        this.setUpRoleUnresolveds();
        RoleUnresolvedList list = new RoleUnresolvedList();
        list.add(this.roleUnresolved1);
        list.add(this.roleUnresolved2);
        list.set(1, this.roleUnresolved1);
        RoleUnresolvedListTestCase.assertEquals((int)2, (int)list.size());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(0).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(1).toString());
        Iterator iterator = list.iterator();
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.set(4, this.roleUnresolved1);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"Shouldn't be able to set a roleUnresolved outside of valid range");
        }
        caught = false;
        try {
            list.add(1, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"Shouldn't be able to set a null at an index");
        }
    }

    public void testMultipleAdd() {
        this.setUpRoleUnresolveds();
        RoleUnresolvedList list = new RoleUnresolvedList();
        list.add(this.roleUnresolved1);
        list.add(this.roleUnresolved1);
        RoleUnresolvedList listToAdd = new RoleUnresolvedList();
        listToAdd.add(this.roleUnresolved2);
        listToAdd.add(this.roleUnresolved2);
        list.addAll(listToAdd);
        RoleUnresolvedListTestCase.assertEquals((int)4, (int)list.size());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(0).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(1).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)list.get(2).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)list.get(3).toString());
        Iterator iterator = list.iterator();
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.addAll((RoleUnresolvedList)null);
        }
        catch (Exception e) {
            caught = true;
        }
        if (caught) {
            RoleUnresolvedListTestCase.fail((String)"Should be able to addAll a null");
        }
    }

    public void testMultipleLocationAdd() {
        this.setUpRoleUnresolveds();
        RoleUnresolvedList list = new RoleUnresolvedList();
        list.add(this.roleUnresolved1);
        list.add(this.roleUnresolved1);
        RoleUnresolvedList listToAdd = new RoleUnresolvedList();
        listToAdd.add(this.roleUnresolved2);
        listToAdd.add(this.roleUnresolved2);
        list.addAll(1, listToAdd);
        RoleUnresolvedListTestCase.assertEquals((int)4, (int)list.size());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(0).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)list.get(1).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)list.get(2).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)list.get(3).toString());
        Iterator iterator = list.iterator();
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.addAll(6, listToAdd);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"Shouldn't be able to addAll a roleUnresolved outside of valid range");
        }
        caught = false;
        try {
            list.addAll(1, (RoleUnresolvedList)null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleUnresolvedListTestCase.fail((String)"Shouldn't be able to addAll a null at an index");
        }
    }

    public void testClone() {
        this.setUpRoleUnresolveds();
        try {
            ArrayList<RoleUnresolved> roleUnresolveds = new ArrayList<RoleUnresolved>();
            roleUnresolveds.add(this.roleUnresolved1);
            roleUnresolveds.add(this.roleUnresolved2);
            RoleUnresolvedList full = new RoleUnresolvedList((List<RoleUnresolved>)roleUnresolveds);
            RoleUnresolvedList clone = (RoleUnresolvedList)full.clone();
            RoleUnresolvedListTestCase.assertEquals((int)2, (int)clone.size());
            RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)clone.get(0).toString());
            RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)clone.get(1).toString());
            Iterator iterator = clone.iterator();
            RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
            RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)iterator.next().toString());
        }
        catch (IllegalArgumentException e) {
            RoleUnresolvedListTestCase.fail((String)"FAILS IN RI: roleUnresolvedList -> RoleList?");
        }
    }

    public void testSerialization() {
        this.setUpRoleUnresolveds();
        ArrayList<RoleUnresolved> roleUnresolveds = new ArrayList<RoleUnresolved>();
        roleUnresolveds.add(this.roleUnresolved1);
        roleUnresolveds.add(this.roleUnresolved2);
        RoleUnresolvedList full = new RoleUnresolvedList((List<RoleUnresolved>)roleUnresolveds);
        ArrayList copy = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(full);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            copy = (RoleUnresolvedList)ois.readObject();
        }
        catch (IOException ioe) {
            RoleUnresolvedListTestCase.fail((String)ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            RoleUnresolvedListTestCase.fail((String)cnfe.toString());
        }
        RoleUnresolvedListTestCase.assertEquals((int)2, (int)copy.size());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)copy.get(0).toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)copy.get(1).toString());
        Iterator iterator = copy.iterator();
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved1.toString(), (String)iterator.next().toString());
        RoleUnresolvedListTestCase.assertEquals((String)this.roleUnresolved2.toString(), (String)iterator.next().toString());
    }

    private void setUpRoleUnresolveds() {
        if (this.setUpDone) {
            return;
        }
        try {
            ArrayList<ObjectName> roleValue1 = new ArrayList<ObjectName>();
            ObjectName a = new ObjectName(":a=a");
            ObjectName b = new ObjectName(":b=b");
            roleValue1.add(a);
            roleValue1.add(b);
            this.roleUnresolved1 = new RoleUnresolved("RoleName1", roleValue1, 2);
            ArrayList<ObjectName> roleValue2 = new ArrayList<ObjectName>();
            ObjectName c = new ObjectName(":c=c");
            ObjectName d = new ObjectName(":d=d");
            roleValue2.add(c);
            roleValue2.add(d);
            this.roleUnresolved2 = new RoleUnresolved("RoleName2", roleValue2, 2);
        }
        catch (MalformedObjectNameException mfone) {
            RoleUnresolvedListTestCase.fail((String)mfone.toString());
        }
        this.setUpDone = true;
    }
}

