/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClassFilter
implements VirtualFileVisitor {
    private static Logger log = Logger.getLogger(AnnotatedClassFilter.class);
    private ClassLoader loader;
    private int rootLength;
    private HashSet<String> childPaths = new HashSet();
    private HashMap<VirtualFile, Class<?>> pathToClasses = new HashMap();
    private String clientClassName;

    public AnnotatedClassFilter(VFSDeploymentUnit unit, ClassLoader loader, VirtualFile classpathRoot) {
        this(unit, loader, classpathRoot, "");
    }

    public AnnotatedClassFilter(VFSDeploymentUnit unit, ClassLoader loader, VirtualFile classpathRoot, String clientClassName) {
        List children;
        this.loader = loader;
        this.clientClassName = clientClassName;
        String rootName = classpathRoot.getPathName();
        this.rootLength = rootName.length();
        if (this.rootLength > 0) {
            ++this.rootLength;
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit cu : children) {
                String path = cu.getName();
                this.childPaths.add(path);
            }
        }
    }

    public Map<VirtualFile, Class<?>> getAnnotatedClasses() {
        return this.pathToClasses;
    }

    public VisitorAttributes getAttributes() {
        VisitorAttributes attributes = new VisitorAttributes();
        attributes.setIncludeRoot(true);
        attributes.setRecurseFilter((VirtualFileFilter)new NoChildFilter());
        return attributes;
    }

    public void visit(VirtualFile file) {
        if (file.isFile()) {
            this.accepts(file);
        }
    }

    public boolean accepts(VirtualFile file) {
        boolean accepts;
        block5: {
            accepts = file.getPathName().endsWith(".class");
            if (accepts) {
                accepts = false;
                String className = null;
                try {
                    className = this.getClassName(file);
                    Class<?> c = this.loader.loadClass(className);
                    boolean hasAnnotations = this.hasAnnotations(c);
                    boolean includeClass = false;
                    includeClass = this.clientClassName != null ? className.equals(this.clientClassName) && hasAnnotations : hasAnnotations;
                    if (includeClass) {
                        this.pathToClasses.put(file, c);
                        accepts = true;
                    }
                }
                catch (NoClassDefFoundError ignored) {
                    log.debug((Object)("Incomplete class: " + className + ", NCDFE: " + ignored));
                }
                catch (Exception ignored) {
                    if (!log.isTraceEnabled()) break block5;
                    log.trace((Object)("Failed to load class: " + className), (Throwable)ignored);
                }
            }
        }
        return accepts;
    }

    protected String getFilePath(VirtualFile file) {
        String path = null;
        try {
            path = file.toURI().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    protected String getClassName(VirtualFile classFile) throws IOException {
        String pathName = classFile.getPathName();
        String name = pathName.substring(this.rootLength, pathName.length() - 6);
        name = name.replace('/', '.');
        return name;
    }

    protected boolean hasAnnotations(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (cls.getAnnotations().length > 0) {
            return true;
        }
        for (Method method : cls.getDeclaredMethods()) {
            if (method.getAnnotations().length <= 0) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            if (accessibleObject.getAnnotations().length <= 0) continue;
            return true;
        }
        return this.hasAnnotations(cls.getSuperclass());
    }

    class NoChildFilter
    implements VirtualFileFilter {
        NoChildFilter() {
        }

        public boolean accepts(VirtualFile file) {
            String path = AnnotatedClassFilter.this.getFilePath(file);
            boolean accepts = false;
            try {
                accepts = !file.isLeaf() && !AnnotatedClassFilter.this.childPaths.contains(path);
            }
            catch (Exception e) {
                // empty catch block
            }
            return accepts;
        }
    }
}

