/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.logging.Logger;

public final class AllowedOperationsAssociation
implements AllowedOperationsFlags {
    private static final Logger log = Logger.getLogger(AllowedOperationsAssociation.class);
    public static final HashMap methodMap = new LinkedHashMap();
    private static ThreadLocal threadLocal;

    public static void pushInMethodFlag(int inMethodFlag) {
        Stack inMethodStack = (Stack)threadLocal.get();
        inMethodStack.push(new Integer(inMethodFlag));
    }

    public static void popInMethodFlag() {
        Stack inMethodStack = (Stack)threadLocal.get();
        inMethodStack.pop();
    }

    public static int peekInMethodFlag() {
        Stack inMethodStack = (Stack)threadLocal.get();
        if (!inMethodStack.isEmpty()) {
            return (Integer)inMethodStack.peek();
        }
        return -1;
    }

    public static String peekInMethodFlagAsString() {
        int currentMethodFlag = AllowedOperationsAssociation.peekInMethodFlag();
        return (String)methodMap.get(new Integer(currentMethodFlag));
    }

    public static void assertAllowedIn(String ctxMethod, int flags) {
        Integer inMethodFlag;
        Stack inMethodStack = (Stack)threadLocal.get();
        if (inMethodStack.empty()) {
            throw new IllegalStateException("Cannot obtain inMethodFlag for: " + ctxMethod);
        }
        if (!inMethodStack.empty() && ((inMethodFlag = (Integer)inMethodStack.peek()) & flags) == 0 && inMethodFlag != IN_INTERCEPTOR_METHOD) {
            String message = ctxMethod + " should not be access from this bean method: " + methodMap.get(inMethodFlag);
            IllegalStateException ex = new IllegalStateException(message);
            log.error((Object)(message + ", allowed is " + AllowedOperationsAssociation.getAllowedMethodList(flags)), (Throwable)ex);
            throw ex;
        }
    }

    private static List getAllowedMethodList(int flags) {
        ArrayList allowed = new ArrayList();
        for (Map.Entry entry : methodMap.entrySet()) {
            Integer flag = (Integer)entry.getKey();
            if ((flag & flags) <= 0) continue;
            allowed.add(entry.getValue());
        }
        return allowed;
    }

    static {
        methodMap.put(new Integer(IN_INTERCEPTOR_METHOD), "IN_INTERCEPTOR_METHOD");
        methodMap.put(new Integer(IN_EJB_ACTIVATE), "IN_EJB_ACTIVATE");
        methodMap.put(new Integer(IN_EJB_PASSIVATE), "IN_EJB_PASSIVATE");
        methodMap.put(new Integer(IN_EJB_REMOVE), "IN_EJB_REMOVE");
        methodMap.put(new Integer(IN_EJB_CREATE), "IN_EJB_CREATE");
        methodMap.put(new Integer(IN_EJB_POST_CREATE), "IN_EJB_POST_CREATE");
        methodMap.put(new Integer(IN_EJB_FIND), "IN_EJB_FIND");
        methodMap.put(new Integer(IN_EJB_HOME), "IN_EJB_HOME");
        methodMap.put(new Integer(IN_EJB_TIMEOUT), "IN_EJB_TIMEOUT");
        methodMap.put(new Integer(IN_EJB_LOAD), "IN_EJB_LOAD");
        methodMap.put(new Integer(IN_EJB_STORE), "IN_EJB_STORE");
        methodMap.put(new Integer(IN_SET_ENTITY_CONTEXT), "IN_SET_ENTITY_CONTEXT");
        methodMap.put(new Integer(IN_UNSET_ENTITY_CONTEXT), "IN_UNSET_ENTITY_CONTEXT");
        methodMap.put(new Integer(IN_SET_SESSION_CONTEXT), "IN_SET_SESSION_CONTEXT");
        methodMap.put(new Integer(IN_SET_MESSAGE_DRIVEN_CONTEXT), "IN_SET_MESSAGE_DRIVEN_CONTEXT");
        methodMap.put(new Integer(IN_AFTER_BEGIN), "IN_AFTER_BEGIN");
        methodMap.put(new Integer(IN_BEFORE_COMPLETION), "IN_BEFORE_COMPLETION");
        methodMap.put(new Integer(IN_AFTER_COMPLETION), "IN_AFTER_COMPLETION");
        methodMap.put(new Integer(IN_BUSINESS_METHOD), "IN_BUSINESS_METHOD");
        methodMap.put(new Integer(IN_SERVICE_ENDPOINT_METHOD), "IN_SERVICE_ENDPOINT_METHOD");
        threadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new Stack();
            }
        };
    }
}

