/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.client;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;
import org.jboss.naming.NamingContextFactory;
import org.jboss.remoting.CannotConnectException;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.usertx.interfaces.UserTransactionSession;
import org.jboss.tm.usertx.interfaces.UserTransactionSessionFactory;

public class ClientUserTransaction
implements UserTransaction,
TransactionPropagationContextFactory,
Referenceable,
Serializable {
    private static final long serialVersionUID = 1747989355209242872L;
    private static ClientUserTransaction singleton = new ClientUserTransaction();
    private static final Logger log = Logger.getLogger(ClientUserTransaction.class);
    private static boolean trace = log.isTraceEnabled();
    private UserTransactionSession session = null;
    private transient ThreadLocal threadInfo = new ThreadLocal();

    public static ClientUserTransaction getSingleton() {
        return singleton;
    }

    private ClientUserTransaction() {
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.getStatus() != 6) {
            throw new NotSupportedException("Attempt to start a nested transaction (the transaction started previously hasn't been ended yet).");
        }
        ThreadInfo info = this.getThreadInfo();
        trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Calling UserTransaction.begin()");
        }
        try {
            Object tpc = this.getSession().begin(info.getTimeout());
            info.push(tpc);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadInfo info = this.getThreadInfo();
        Object tpc = info.getTpc();
        if (trace) {
            log.trace((Object)("Calling UserTransaction.commit(" + tpc + ")"));
        }
        try {
            this.getSession().commit(tpc);
        }
        catch (RollbackException e) {
            throw e;
        }
        catch (HeuristicMixedException e) {
            throw e;
        }
        catch (HeuristicRollbackException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (SystemException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
        catch (CannotConnectException e) {
            this.destroySession();
            this.logCauseException((Exception)((Object)e));
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
        finally {
            info.pop();
        }
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        ThreadInfo info = this.getThreadInfo();
        Object tpc = info.getTpc();
        if (trace) {
            log.trace((Object)("Calling UserTransaction.rollback(" + tpc + ")"));
        }
        try {
            this.getSession().rollback(tpc);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (SystemException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
        catch (CannotConnectException e) {
            this.destroySession();
            this.logCauseException((Exception)((Object)e));
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
        finally {
            info.pop();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadInfo info = this.getThreadInfo();
        Object tpc = info.getTpc();
        if (trace) {
            log.trace((Object)("Calling UserTransaction.setRollbackOnly(" + tpc + ")"));
        }
        try {
            this.getSession().setRollbackOnly(tpc);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
    }

    public int getStatus() throws SystemException {
        ThreadInfo info = this.getThreadInfo();
        Object tpc = info.getTpc();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Calling UserTransaction.getStatus(" + tpc + ")"));
        }
        if (tpc == null) {
            return 6;
        }
        try {
            return this.getSession().getStatus(tpc);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            this.logCauseException(e);
            throw new SystemException(e.toString());
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getThreadInfo().setTimeout(seconds);
    }

    public Object getTransactionPropagationContext() {
        return this.getThreadInfo().getTpc();
    }

    public Object getTransactionPropagationContext(Transaction tx) {
        throw new InternalError("Should not have been used.");
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference("org.jboss.tm.usertx.client.ClientUserTransaction", "org.jboss.tm.usertx.client.ClientUserTransactionObjectFactory", null);
        return ref;
    }

    private synchronized void createSession() {
        if (this.session != null) {
            this.destroySession();
        }
        try {
            Hashtable env = (Hashtable)NamingContextFactory.lastInitialContextEnv.get();
            InitialContext ctx = new InitialContext(env);
            UserTransactionSessionFactory factory = (UserTransactionSessionFactory)ctx.lookup("UserTransactionSessionFactory");
            this.session = factory.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("UT factory lookup failed", ex);
        }
    }

    private synchronized void destroySession() {
        if (this.session != null) {
            try {
                this.session.destroy();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.session = null;
        }
    }

    private synchronized UserTransactionSession getSession() {
        if (this.session == null) {
            this.createSession();
        }
        return this.session;
    }

    private ThreadInfo getThreadInfo() {
        ThreadInfo ret = (ThreadInfo)this.threadInfo.get();
        if (ret == null) {
            ret = new ThreadInfo();
            this.threadInfo.set(ret);
        }
        if (trace) {
            log.trace((Object)("Thread local: " + this.threadInfo));
            log.trace((Object)("Thread info holder: " + ret));
        }
        return ret;
    }

    private void logCauseException(Exception e) {
        if (trace) {
            log.trace((Object)"Logging cause exception", (Throwable)e);
        }
    }

    private class ThreadInfo {
        private LinkedList tpcStack = new LinkedList();
        private int timeout = 0;

        private ThreadInfo() {
        }

        protected void finalize() throws Throwable {
            if (trace) {
                log.trace((Object)("Tpc stack: finalize " + this));
            }
            block4: while (true) {
                try {
                    while (!this.tpcStack.isEmpty()) {
                        Object tpc = this.getTpc();
                        this.pop();
                        try {
                            ClientUserTransaction.this.getSession().rollback(tpc);
                            continue block4;
                        }
                        catch (Exception exception) {
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break;
                }
            }
            super.finalize();
        }

        void push(Object tpc) {
            this.tpcStack.addLast(tpc);
            if (trace) {
                log.trace((Object)("Tpc stack: added " + this + " tpc=" + tpc));
            }
        }

        void pop() {
            Object tpc = this.tpcStack.removeLast();
            if (trace) {
                log.trace((Object)("Tpc stack: removed " + this + " tpc=" + tpc));
            }
        }

        Object getTpc() {
            Object tpc;
            Object v0 = tpc = this.tpcStack.isEmpty() ? null : this.tpcStack.getLast();
            if (trace) {
                log.trace((Object)("Tpc stack: peek " + this + " tpc=" + tpc));
            }
            return tpc;
        }

        int getTimeout() {
            return this.timeout;
        }

        void setTimeout(int seconds) {
            this.timeout = seconds;
        }
    }
}

